/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing;

import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.parsing.ISourceFragment;

public class SourceFragment
implements ISourceFragment {
    private String physicalText;
    private String logicalText;
    private int physicalStart;
    private int physicalLine;
    private int physicalColumn;

    public SourceFragment(String physicalText, String logicalText, int physicalStart, int physicalLine, int physicalColumn) {
        this.physicalText = physicalText;
        this.logicalText = logicalText;
        this.physicalStart = physicalStart;
        this.physicalLine = physicalLine;
        this.physicalColumn = physicalColumn;
    }

    public SourceFragment(String physicalText, String logicalText, ISourceLocation location) {
        this(physicalText, logicalText, location.getStart(), location.getLine(), location.getColumn());
    }

    public SourceFragment(String text, ISourceLocation location) {
        this(text, text, location);
    }

    @Override
    public String getPhysicalText() {
        return this.physicalText;
    }

    @Override
    public String getLogicalText() {
        return this.logicalText;
    }

    @Override
    public int getPhysicalStart() {
        return this.physicalStart;
    }

    public void setPhysicalStart(int physicalStart) {
        this.physicalStart = physicalStart;
    }

    @Override
    public int getPhysicalLine() {
        return this.physicalLine;
    }

    @Override
    public int getPhysicalColumn() {
        return this.physicalColumn;
    }

    public ISourceFragment subfragment(int beginIndex, int endIndex) {
        assert (0 <= beginIndex && beginIndex <= this.logicalText.length()) : "Invalid beginIndex";
        assert (0 <= endIndex && endIndex <= this.logicalText.length()) : "Invalid endIndex";
        if (beginIndex == endIndex) {
            return null;
        }
        return new SourceFragment(this.physicalText.substring(beginIndex, endIndex), this.logicalText.substring(beginIndex, endIndex), this.physicalStart + beginIndex, this.physicalLine, this.physicalColumn + beginIndex);
    }

    public String toString() {
        return "\"" + this.physicalText + "\"";
    }
}

