/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter;

import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.common.IFileSpecificationGetter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.parsing.as.ASParser;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.parsing.as.IncludeHandler;
import org.apache.royale.compiler.internal.parsing.as.RepairingTokenBuffer;
import org.apache.royale.compiler.internal.parsing.as.StreamingASTokenizer;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.LinterSettings;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.TokenVisitor;
import org.apache.royale.linter.internal.BaseLinter;

public class ASLinter
extends BaseLinter {
    private static final String LINTER_TAG_OFF = "@linter:off";
    private static final String LINTER_TAG_ON = "@linter:on";

    public ASLinter(LinterSettings settings) {
        super(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lint(String filePath, String text, Collection<ICompilerProblem> allProblems) {
        if (allProblems == null) {
            allProblems = new ArrayList<ICompilerProblem>();
        }
        ArrayList<ICompilerProblem> fileProblems = new ArrayList<ICompilerProblem>();
        try {
            StringReader textReader = new StringReader(text);
            StreamingASTokenizer tokenizer = null;
            ASToken[] streamingTokens = null;
            try {
                tokenizer = StreamingASTokenizer.createForRepairingASTokenizer(textReader, filePath, IncludeHandler.creatDefaultIncludeHandler());
                tokenizer.setCollectComments(true);
                tokenizer.setFollowIncludes(false);
                streamingTokens = tokenizer.getTokens(textReader);
            }
            finally {
                IOUtils.closeQuietly((Reader)textReader);
                IOUtils.closeQuietly((Closeable)tokenizer);
            }
            if (tokenizer.hasTokenizationProblems()) {
                fileProblems.addAll(tokenizer.getTokenizationProblems());
            }
            if (!this.settings.ignoreProblems && this.hasErrors(fileProblems)) {
                return;
            }
            ArrayList<ASToken> comments = new ArrayList<ASToken>();
            ArrayList<ASToken> streamingTokensList = new ArrayList<ASToken>();
            for (ASToken token : streamingTokens) {
                if (token.getType() == 5 || token.getType() == 8) {
                    comments.add(token);
                    continue;
                }
                streamingTokensList.add(token);
            }
            Workspace workspace = new Workspace();
            RepairingTokenBuffer buffer = new RepairingTokenBuffer(streamingTokensList.toArray(new ASToken[0]));
            ASParser parser = new ASParser(workspace, buffer);
            FileNode node = new FileNode((IFileSpecificationGetter)workspace);
            try {
                parser.parseFile(node, (EnumSet)EnumSet.of(PostProcessStep.CALCULATE_OFFSETS));
            }
            catch (Exception e) {
                parser = null;
                fileProblems.add((ICompilerProblem)new UnexpectedExceptionProblem((Throwable)e));
                allProblems.addAll(fileProblems);
                return;
            }
            if (tokenizer.hasTokenizationProblems()) {
                fileProblems.addAll(tokenizer.getTokenizationProblems());
            }
            if (parser.getSyntaxProblems().size() > 0) {
                fileProblems.addAll(parser.getSyntaxProblems());
            }
            if (!this.settings.ignoreProblems && this.hasErrors(fileProblems)) {
                return;
            }
            List<IASToken> repairedTokensList = new ArrayList<IASToken>(Arrays.asList(buffer.getTokens(true)));
            IASToken nextComment = null;
            for (int i = 0; i < repairedTokensList.size(); ++i) {
                if (nextComment == null) {
                    if (comments.size() == 0) break;
                    nextComment = (IASToken)comments.get(0);
                }
                IASToken currentToken = (IASToken)repairedTokensList.get(i);
                if (nextComment.getAbsoluteStart() > currentToken.getAbsoluteStart()) continue;
                repairedTokensList.add(i, nextComment);
                nextComment = null;
                comments.remove(0);
            }
            repairedTokensList.addAll(comments);
            repairedTokensList = this.insertWhitespaceTokens(repairedTokensList, text);
            IASToken[] allTokens = repairedTokensList.toArray(new IASToken[0]);
            TokenQuery tokenQuery = new TokenQuery(allTokens);
            this.visitNode(node, tokenQuery, fileProblems);
            boolean skipLinting = false;
            for (LinterRule rule : this.settings.rules) {
                Map<Integer, TokenVisitor> tokenHandlers = rule.getTokenVisitors();
                if (tokenHandlers == null) continue;
                for (IASToken token : allTokens) {
                    int tokenType = token.getType();
                    if (tokenType == 5 || tokenType == 8) {
                        boolean isMultiline = tokenType == 8;
                        String tokenText = token.getText();
                        String trimmed = tokenText.substring(2, tokenText.length() - (isMultiline ? 2 : 0)).trim();
                        if (!skipLinting && LINTER_TAG_OFF.equals(trimmed)) {
                            skipLinting = true;
                        } else if (skipLinting && LINTER_TAG_ON.equals(trimmed)) {
                            skipLinting = false;
                            continue;
                        }
                    }
                    if (skipLinting || !tokenHandlers.containsKey(tokenType)) continue;
                    tokenHandlers.get(tokenType).visit(token, tokenQuery, fileProblems);
                }
            }
        }
        finally {
            allProblems.addAll(fileProblems);
        }
    }

    private void visitNode(IASNode node, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        ASTNodeID nodeID = node.getNodeID();
        IASToken prevComment = tokenQuery.getCommentBefore((ISourceLocation)node);
        boolean linterOn = true;
        while (prevComment != null) {
            Object commentText = null;
            if (prevComment.getType() == 5) {
                commentText = prevComment.getText().substring(2).trim();
            } else if (prevComment.getType() == 8) {
                commentText = prevComment.getText();
                commentText = ((String)commentText).substring(2, ((String)commentText).length() - 2).trim();
            } else {
                prevComment = tokenQuery.getCommentBefore((ISourceLocation)prevComment);
                continue;
            }
            if (LINTER_TAG_ON.equals(commentText)) {
                linterOn = true;
                break;
            }
            if (LINTER_TAG_OFF.equals(commentText)) {
                linterOn = false;
                break;
            }
            prevComment = tokenQuery.getCommentBefore((ISourceLocation)prevComment);
        }
        if (linterOn) {
            for (LinterRule rule : this.settings.rules) {
                Map<ASTNodeID, NodeVisitor> nodeHandlers = rule.getNodeVisitors();
                if (nodeHandlers == null || !nodeHandlers.containsKey(nodeID)) continue;
                nodeHandlers.get(nodeID).visit(node, tokenQuery, problems);
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            IASNode child = node.getChild(i);
            this.visitNode(child, tokenQuery, problems);
        }
    }

    private List<IASToken> insertWhitespaceTokens(List<IASToken> originalTokens, String text) {
        ArrayList<IASToken> tokens = new ArrayList<IASToken>();
        IASToken prevToken = null;
        for (IASToken token : originalTokens) {
            if (prevToken != null) {
                boolean skipSemicolon;
                boolean bl = skipSemicolon = token.getType() == 55 && token.isImplicit() && prevToken != null && (prevToken.getType() == 5 || prevToken.getType() == 22);
                if (skipSemicolon) continue;
                int start = prevToken.getAbsoluteEnd();
                int end = token.getAbsoluteStart();
                if (end > start) {
                    String tokenText = text.substring(start, end);
                    ASToken whitespaceToken = new ASToken(999999, start, end, prevToken.getEndLine(), prevToken.getEndColumn(), tokenText);
                    whitespaceToken.setEndLine(token.getLine());
                    whitespaceToken.setEndLine(token.getColumn());
                    tokens.add(whitespaceToken);
                }
            }
            tokens.add(token);
            prevToken = token;
        }
        if (prevToken != null) {
            int start = prevToken.getAbsoluteEnd();
            int end = text.length();
            if (end > start) {
                String tokenText = text.substring(start, end);
                ASToken whitespaceToken = new ASToken(999999, start, end, prevToken.getEndLine(), prevToken.getEndColumn(), tokenText);
                whitespaceToken.setEndLine(prevToken.getLine());
                whitespaceToken.setEndLine(prevToken.getColumn());
                tokens.add(whitespaceToken);
            }
        }
        return tokens;
    }
}

