/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.regex.Pattern;

public class ExportTestFunctions
implements CompilerPass {
    private static final Pattern TEST_FUNCTIONS_NAME_PATTERN = Pattern.compile("^(?:((\\w+\\.)+prototype\\.||window\\.)*(setUpPage|setUp|shouldRunTests|tearDown|tearDownPage|test[\\w\\$]+))$");
    private final AbstractCompiler compiler;
    private final String exportSymbolFunction;
    private final String exportPropertyFunction;

    ExportTestFunctions(AbstractCompiler compiler, String exportSymbolFunction, String exportPropertyFunction) {
        Preconditions.checkNotNull(compiler);
        this.compiler = compiler;
        this.exportSymbolFunction = exportSymbolFunction;
        this.exportPropertyFunction = exportPropertyFunction;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new ExportTestFunctionsNodes());
    }

    private void exportTestFunctionAsSymbol(String testFunctionName, Node node, Node scriptNode) {
        Node exportCallTarget = NodeUtil.newQName(this.compiler, this.exportSymbolFunction, node, testFunctionName);
        Node call = IR.call(exportCallTarget, new Node[0]);
        if (exportCallTarget.isName()) {
            call.putBooleanProp(Node.FREE_CALL, true);
        }
        call.addChildToBack(IR.string(testFunctionName));
        call.addChildToBack(NodeUtil.newQName(this.compiler, testFunctionName, node, testFunctionName));
        Node expression = IR.exprResult(call);
        scriptNode.addChildAfter(expression, node);
        this.compiler.reportChangeToEnclosingScope(expression);
    }

    private void exportTestFunctionAsProperty(String fullyQualifiedFunctionName, Node parent, Node node, Node scriptNode) {
        String testFunctionName = NodeUtil.getPrototypePropertyName(node.getFirstChild());
        if (node.getFirstChild().getQualifiedName().startsWith("window.")) {
            testFunctionName = node.getFirstChild().getQualifiedName().substring("window.".length());
        }
        String objectName = fullyQualifiedFunctionName.substring(0, fullyQualifiedFunctionName.lastIndexOf(46));
        String exportCallStr = SimpleFormat.format("%s(%s, '%s', %s);", this.exportPropertyFunction, objectName, testFunctionName, fullyQualifiedFunctionName);
        Node exportCall = this.compiler.parseSyntheticCode(exportCallStr).removeChildren();
        exportCall.useSourceInfoFromForTree(scriptNode);
        scriptNode.addChildrenAfter(exportCall, parent);
        this.compiler.reportChangeToEnclosingScope(exportCall);
    }

    public static boolean isTestFunction(String functionName) {
        return functionName != null && TEST_FUNCTIONS_NAME_PATTERN.matcher(functionName).matches();
    }

    private class ExportTestFunctionsNodes
    extends NodeTraversal.AbstractShallowCallback {
        private ExportTestFunctionsNodes() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            block11: {
                block14: {
                    String nodeName;
                    Node lastChild;
                    Node grandparent;
                    block15: {
                        block9: {
                            block13: {
                                block12: {
                                    block10: {
                                        if (parent == null) {
                                            return;
                                        }
                                        if (!parent.isScript()) break block9;
                                        if (!NodeUtil.isFunctionDeclaration(n)) break block10;
                                        String functionName = NodeUtil.getName(n);
                                        if (ExportTestFunctions.isTestFunction(functionName)) {
                                            ExportTestFunctions.this.exportTestFunctionAsSymbol(functionName, n, parent);
                                        }
                                        break block11;
                                    }
                                    if (!this.isNameDeclaredFunction(n)) break block12;
                                    Node functionNode = n.getFirstFirstChild();
                                    String functionName = NodeUtil.getName(functionNode);
                                    if (ExportTestFunctions.isTestFunction(functionName)) {
                                        ExportTestFunctions.this.exportTestFunctionAsSymbol(functionName, n, parent);
                                    }
                                    break block11;
                                }
                                if (!this.isNameDeclaredClass(n)) break block13;
                                Node classNode = n.getFirstFirstChild();
                                String className = NodeUtil.getName(classNode);
                                this.exportClass(parent, classNode, className, n);
                                break block11;
                            }
                            if (!n.isClass()) break block11;
                            this.exportClass(parent, n);
                            break block11;
                        }
                        if (!NodeUtil.isExprAssign(parent) || n.getLastChild().isAssign()) break block14;
                        grandparent = parent.getParent();
                        if (grandparent == null || !grandparent.isScript()) break block11;
                        Node firstChild = n.getFirstChild();
                        lastChild = n.getLastChild();
                        nodeName = firstChild.getQualifiedName();
                        if (!lastChild.isFunction()) break block15;
                        if (ExportTestFunctions.isTestFunction(nodeName)) {
                            if (n.getFirstChild().isName()) {
                                ExportTestFunctions.this.exportTestFunctionAsSymbol(nodeName, parent, grandparent);
                            } else {
                                ExportTestFunctions.this.exportTestFunctionAsProperty(nodeName, parent, n, grandparent);
                            }
                        }
                        break block11;
                    }
                    if (!lastChild.isClass()) break block11;
                    this.exportClass(grandparent, lastChild, nodeName, parent);
                    break block11;
                }
                if (n.isObjectLit() && this.isCallTargetQName(n.getParent(), "goog.testing.testSuite")) {
                    for (Node c : n.children()) {
                        if (c.isStringKey() && !c.isQuotedString()) {
                            c.setQuotedString();
                            ExportTestFunctions.this.compiler.reportChangeToEnclosingScope(c);
                            continue;
                        }
                        if (!c.isMemberFunctionDef()) continue;
                        this.rewriteMemberDefInObjLit(c, n);
                    }
                }
            }
        }

        private void exportClass(Node scriptNode, Node classNode) {
            String className = NodeUtil.getName(classNode);
            this.exportClass(scriptNode, classNode, className, classNode);
        }

        private void exportClass(Node scriptNode, Node classNode, String className, Node addAfter) {
            Node classMembers = classNode.getLastChild();
            for (Node maybeMemberFunctionDef : classMembers.children()) {
                String methodName;
                if (!maybeMemberFunctionDef.isMemberFunctionDef() || !ExportTestFunctions.isTestFunction(methodName = maybeMemberFunctionDef.getString())) continue;
                String functionRef = className + ".prototype." + methodName;
                String classRef = className + ".prototype";
                Node exportCallTarget = NodeUtil.newQName(ExportTestFunctions.this.compiler, ExportTestFunctions.this.exportPropertyFunction, maybeMemberFunctionDef, methodName);
                Node call = IR.call(exportCallTarget, new Node[0]);
                if (exportCallTarget.isName()) {
                    call.putBooleanProp(Node.FREE_CALL, true);
                }
                call.addChildToBack(NodeUtil.newQName(ExportTestFunctions.this.compiler, classRef, maybeMemberFunctionDef, classRef));
                call.addChildToBack(IR.string(methodName));
                call.addChildToBack(NodeUtil.newQName(ExportTestFunctions.this.compiler, functionRef, maybeMemberFunctionDef, functionRef));
                Node expression = IR.exprResult(call);
                scriptNode.addChildAfter(expression, addAfter);
                ExportTestFunctions.this.compiler.reportChangeToEnclosingScope(expression);
                addAfter = expression;
            }
        }

        private void rewriteMemberDefInObjLit(Node memberDef, Node objLit) {
            String name = memberDef.getString();
            Node stringKey = IR.stringKey(name, memberDef.getFirstChild().detach());
            objLit.replaceChild(memberDef, stringKey);
            stringKey.setQuotedString();
            stringKey.setJSDocInfo(memberDef.getJSDocInfo());
            ExportTestFunctions.this.compiler.reportChangeToEnclosingScope(objLit);
        }

        private boolean isCallTargetQName(Node n, String qname) {
            return n.isCall() && n.getFirstChild().matchesQualifiedName(qname);
        }

        private Node getNameDeclaredGrandchild(Node node) {
            if (!NodeUtil.isNameDeclaration(node)) {
                return null;
            }
            return node.getFirstFirstChild();
        }

        private boolean isNameDeclaredFunction(Node node) {
            Node grandchild = this.getNameDeclaredGrandchild(node);
            return grandchild != null && grandchild.isFunction();
        }

        private boolean isNameDeclaredClass(Node node) {
            Node grandchild = this.getNameDeclaredGrandchild(node);
            return grandchild != null && grandchild.isClass();
        }
    }
}

