/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.ITypeNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class LocalVarShadowsFieldRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.VariableID, (node, tokenQuery, problems) -> this.checkVariableNode((IVariableNode)node, tokenQuery, problems));
        return result;
    }

    private void checkVariableNode(IVariableNode variableNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IScopedNode containingScope = variableNode.getContainingScope();
        if (containingScope == null) {
            return;
        }
        IASNode possibleType = containingScope.getParent();
        if (possibleType instanceof ITypeNode || possibleType instanceof IPackageNode) {
            return;
        }
        IClassNode containingClass = (IClassNode)variableNode.getAncestorOfType(IClassNode.class);
        if (containingClass == null) {
            return;
        }
        IScopedNode classScope = containingClass.getScopedNode();
        for (int i = 0; i < classScope.getChildCount(); ++i) {
            IASNode child = classScope.getChild(i);
            if (!(child instanceof IVariableNode)) continue;
            IVariableNode childVar = (IVariableNode)child;
            if (!variableNode.getName().equals(childVar.getName())) continue;
            problems.add(new LocalVarShadowsFieldLinterProblem(variableNode, containingClass));
            return;
        }
    }

    public static class LocalVarShadowsFieldLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Local variable '${varName}' has the same name as field in class '${className}'";
        public String varName;
        public String className;

        public LocalVarShadowsFieldLinterProblem(IVariableNode variableNode, IClassNode classNode) {
            super((ISourceLocation)variableNode.getNameExpressionNode());
            this.varName = variableNode.getName();
            this.className = classNode.getName();
        }
    }
}

