/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.stream;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.stream.CommitLogInputStream;
import org.apache.rocketmq.tieredstore.stream.FileSegmentInputStream;

public class FileSegmentInputStreamFactory {
    public static FileSegmentInputStream build(FileSegmentType fileType, long offset, List<ByteBuffer> bufferList, ByteBuffer byteBuffer, int length) {
        if (bufferList == null) {
            throw new IllegalArgumentException("bufferList is null");
        }
        switch (fileType) {
            case COMMIT_LOG: {
                return new CommitLogInputStream(fileType, offset, bufferList, byteBuffer, length);
            }
            case CONSUME_QUEUE: {
                return new FileSegmentInputStream(fileType, bufferList, length);
            }
            case INDEX: {
                if (bufferList.size() != 1) {
                    throw new IllegalArgumentException("buffer block size must be 1 when file type is IndexFile");
                }
                return new FileSegmentInputStream(fileType, bufferList, length);
            }
        }
        throw new IllegalArgumentException("file type not supported");
    }
}

