/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ratis.shell.cli.AbstractShell;
import org.apache.ratis.shell.cli.Command;
import org.apache.ratis.shell.cli.sh.command.AbstractParentCommand;
import org.apache.ratis.shell.cli.sh.command.Context;
import org.apache.ratis.shell.cli.sh.command.ElectionCommand;
import org.apache.ratis.shell.cli.sh.command.GroupCommand;
import org.apache.ratis.shell.cli.sh.command.LocalCommand;
import org.apache.ratis.shell.cli.sh.command.PeerCommand;
import org.apache.ratis.shell.cli.sh.command.SnapshotCommand;

public class RatisShell
extends AbstractShell {
    static final List<Function<Context, AbstractParentCommand>> PARENT_COMMAND_CONSTRUCTORS = Collections.unmodifiableList(Arrays.asList(PeerCommand::new, GroupCommand::new, ElectionCommand::new, SnapshotCommand::new, LocalCommand::new));

    static List<AbstractParentCommand> allParentCommands(Context context) {
        return PARENT_COMMAND_CONSTRUCTORS.stream().map(constructor -> (AbstractParentCommand)constructor.apply(context)).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        RatisShell shell = new RatisShell(System.out);
        System.exit(shell.run(args));
    }

    public RatisShell(PrintStream out) {
        super(new Context(out));
    }

    @Override
    protected String getShellName() {
        return "sh";
    }

    @Override
    protected Map<String, Command> loadCommands(Context context) {
        return RatisShell.allParentCommands(context).stream().collect(Collectors.toMap(Command::getCommandName, Function.identity()));
    }
}

