/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.client.retry.ClientRetryEvent;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.SlidingWindow;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrderedAsync {
    public static final Logger LOG = LoggerFactory.getLogger(OrderedAsync.class);
    private final RaftClientImpl client;
    private final ConcurrentMap<String, SlidingWindow.Client<PendingOrderedRequest, RaftClientReply>> slidingWindows = new ConcurrentHashMap<String, SlidingWindow.Client<PendingOrderedRequest, RaftClientReply>>();
    private final Semaphore requestSemaphore;

    static OrderedAsync newInstance(RaftClientImpl client, RaftProperties properties) {
        OrderedAsync ordered = new OrderedAsync(client, properties);
        if (RaftClientConfigKeys.Async.Experimental.sendDummyRequest(properties)) {
            ordered.send(RaftClientRequest.watchRequestType(), null, null);
        }
        return ordered;
    }

    private OrderedAsync(RaftClientImpl client, RaftProperties properties) {
        this.client = Objects.requireNonNull(client, "client == null");
        this.requestSemaphore = new Semaphore(RaftClientConfigKeys.Async.outstandingRequestsMax(properties));
    }

    private void resetSlidingWindow(RaftClientRequest request) {
        this.getSlidingWindow(request).resetFirstSeqNum();
    }

    private SlidingWindow.Client<PendingOrderedRequest, RaftClientReply> getSlidingWindow(RaftClientRequest request) {
        return this.getSlidingWindow(request.isToLeader() ? null : request.getServerId());
    }

    private SlidingWindow.Client<PendingOrderedRequest, RaftClientReply> getSlidingWindow(RaftPeerId target) {
        String id = target != null ? target.toString() : "RAFT";
        return this.slidingWindows.computeIfAbsent(id, key -> new SlidingWindow.Client(this.client.getId() + "->" + key));
    }

    private void failAllAsyncRequests(RaftClientRequest request, Throwable t2) {
        this.getSlidingWindow(request).fail(request.getSlidingWindowEntry().getSeqNum(), t2);
    }

    private void handleAsyncRetryFailure(ClientRetryEvent event) {
        this.failAllAsyncRequests(event.getRequest(), this.client.noMoreRetries(event));
    }

    CompletableFuture<RaftClientReply> send(RaftClientRequest.Type type, Message message, RaftPeerId server) {
        if (!type.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH) && !type.is(RaftProtos.RaftClientRequestProto.TypeCase.MESSAGESTREAM)) {
            Objects.requireNonNull(message, "message == null");
        }
        try {
            this.requestSemaphore.acquire();
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            return JavaUtils.completeExceptionally(IOUtils.toInterruptedIOException("Interrupted when sending " + type + ", message=" + message, e2));
        }
        long callId = CallId.getAndIncrement();
        LongFunction<PendingOrderedRequest> constructor = seqNum -> new PendingOrderedRequest(callId, seqNum, slidingWindowEntry -> this.client.newRaftClientRequest(server, callId, message, type, (RaftProtos.SlidingWindowEntry)slidingWindowEntry));
        return ((CompletableFuture)this.getSlidingWindow(server).submitNewRequest(constructor, this::sendRequestWithRetry).getReplyFuture().thenApply(reply -> RaftClientImpl.handleRaftException(reply, CompletionException::new))).whenComplete((r, e) -> {
            if (e != null) {
                if (e.getCause() instanceof AlreadyClosedException) {
                    LOG.error("Failed to send request, message=" + message + " due to " + e);
                } else {
                    LOG.error("Failed to send request, message=" + message, (Throwable)e);
                }
            }
            this.requestSemaphore.release();
        });
    }

    private void sendRequestWithRetry(PendingOrderedRequest pending) {
        if (pending == null) {
            return;
        }
        CompletableFuture<RaftClientReply> f = pending.getReplyFuture();
        if (f.isDone()) {
            return;
        }
        RaftClientRequest request = pending.newRequestImpl();
        if (request == null) {
            LOG.debug("{} newRequestImpl returns null", (Object)pending);
            return;
        }
        RetryPolicy retryPolicy = this.client.getRetryPolicy();
        this.sendRequest(pending).exceptionally(e -> {
            if (e instanceof CompletionException) {
                e = JavaUtils.unwrapCompletionException(e);
                this.scheduleWithTimeout(pending, request, retryPolicy, (Throwable)e);
                return null;
            }
            f.completeExceptionally((Throwable)e);
            return null;
        });
    }

    private void scheduleWithTimeout(PendingOrderedRequest pending, RaftClientRequest request, RetryPolicy retryPolicy, Throwable e) {
        int attempt = pending.getAttemptCount();
        ClientRetryEvent event = new ClientRetryEvent(request, e, pending);
        TimeDuration sleepTime = this.client.getEffectiveSleepTime(e, retryPolicy.handleAttemptFailure(event).getSleepTime());
        LOG.debug("schedule* attempt #{} with sleep {} and policy {} for {}", attempt, sleepTime, retryPolicy, request);
        this.scheduleWithTimeout(pending, sleepTime, this.getSlidingWindow(request));
    }

    private void scheduleWithTimeout(PendingOrderedRequest pending, TimeDuration sleepTime, SlidingWindow.Client<PendingOrderedRequest, RaftClientReply> slidingWindow) {
        this.client.getScheduler().onTimeout(sleepTime, () -> slidingWindow.retry(pending, this::sendRequestWithRetry), LOG, () -> "Failed* to retry " + pending);
    }

    private CompletableFuture<RaftClientReply> sendRequest(PendingOrderedRequest pending) {
        RetryPolicy retryPolicy = this.client.getRetryPolicy();
        if (this.getSlidingWindow((RaftPeerId)null).isFirst(pending.getSeqNum())) {
            pending.setFirstRequest();
        }
        RaftClientRequest request = pending.newRequest();
        LOG.debug("{}: send* {}", (Object)this.client.getId(), (Object)request);
        return ((CompletableFuture)this.client.getClientRpc().sendRequestAsync(request).thenApply(reply -> {
            LOG.debug("{}: receive* {}", (Object)this.client.getId(), reply);
            Objects.requireNonNull(reply, "reply == null");
            this.client.handleReply(request, (RaftClientReply)reply);
            this.getSlidingWindow(request).receiveReply(request.getSlidingWindowEntry().getSeqNum(), (RaftClientReply)reply, this::sendRequestWithRetry);
            return reply;
        })).exceptionally(e -> {
            LOG.error(this.client.getId() + ": Failed* " + request, (Throwable)e);
            e = JavaUtils.unwrapCompletionException(e);
            if (e instanceof IOException && !(e instanceof GroupMismatchException)) {
                pending.incrementExceptionCount((Throwable)e);
                ClientRetryEvent event = new ClientRetryEvent(request, (Throwable)e, pending);
                if (!retryPolicy.handleAttemptFailure(event).shouldRetry()) {
                    this.handleAsyncRetryFailure(event);
                } else if (e instanceof NotLeaderException) {
                    NotLeaderException nle = (NotLeaderException)e;
                    this.client.handleNotLeaderException(request, nle, this::resetSlidingWindow);
                } else {
                    this.client.handleIOException(request, (IOException)e, null, this::resetSlidingWindow);
                }
                throw new CompletionException((Throwable)e);
            }
            this.failAllAsyncRequests(request, (Throwable)e);
            return null;
        });
    }

    void assertRequestSemaphore(int expectedAvailablePermits, int expectedQueueLength) {
        Preconditions.assertSame(expectedAvailablePermits, this.requestSemaphore.availablePermits(), "availablePermits");
        Preconditions.assertSame(expectedQueueLength, this.requestSemaphore.getQueueLength(), "queueLength");
    }

    static class PendingOrderedRequest
    extends RaftClientImpl.PendingClientRequest
    implements SlidingWindow.ClientSideRequest<RaftClientReply> {
        private final long callId;
        private final long seqNum;
        private final AtomicReference<Function<RaftProtos.SlidingWindowEntry, RaftClientRequest>> requestConstructor;
        private volatile boolean isFirst = false;

        PendingOrderedRequest(long callId, long seqNum, Function<RaftProtos.SlidingWindowEntry, RaftClientRequest> requestConstructor) {
            this.callId = callId;
            this.seqNum = seqNum;
            this.requestConstructor = new AtomicReference<Function<RaftProtos.SlidingWindowEntry, RaftClientRequest>>(requestConstructor);
        }

        @Override
        public RaftClientRequest newRequestImpl() {
            return Optional.ofNullable(this.requestConstructor.get()).map(f -> (RaftClientRequest)f.apply(ProtoUtils.toSlidingWindowEntry(this.seqNum, this.isFirst))).orElse(null);
        }

        @Override
        public void setFirstRequest() {
            this.isFirst = true;
        }

        @Override
        public long getSeqNum() {
            return this.seqNum;
        }

        @Override
        public boolean hasReply() {
            return this.getReplyFuture().isDone();
        }

        @Override
        public void setReply(RaftClientReply reply) {
            this.requestConstructor.set(null);
            this.getReplyFuture().complete(reply);
        }

        @Override
        public void fail(Throwable e) {
            this.requestConstructor.set(null);
            this.getReplyFuture().completeExceptionally(e);
        }

        public String toString() {
            return "[cid=" + this.callId + ", seq=" + this.getSeqNum() + "]";
        }
    }
}

