/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.function.ToIntFunction;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ValidationException;
import javax.validation.constraints.Size;

public abstract class SizeValidator<T>
implements ConstraintValidator<Size, T> {
    private final ToIntFunction<? super T> sizeOf;
    protected int min;
    protected int max;

    protected SizeValidator(ToIntFunction<? super T> sizeOf) {
        this.sizeOf = sizeOf;
    }

    public void initialize(Size constraint) {
        this.min = constraint.min();
        this.max = constraint.max();
        if (this.min < 0) {
            throw new ValidationException("Min cannot be negative");
        }
        if (this.max < 0) {
            throw new ValidationException("Max cannot be negative");
        }
        if (this.max < this.min) {
            throw new ValidationException("Max cannot be less than Min");
        }
    }

    public boolean isValid(T value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        int size = this.sizeOf.applyAsInt(value);
        return this.min <= size && size <= this.max;
    }

    public static class ForMap
    extends SizeValidator<Map<?, ?>> {
        public ForMap() {
            super(Map::size);
        }
    }

    public static class ForCollection
    extends SizeValidator<Collection<?>> {
        public ForCollection() {
            super(Collection::size);
        }
    }

    public static class ForCharSequence
    extends SizeValidator<CharSequence> {
        public ForCharSequence() {
            super(CharSequence::length);
        }
    }

    public static class ForArray<T>
    extends SizeValidator<T> {
        protected ForArray() {
            super(Array::getLength);
        }

        public static class OfBoolean
        extends ForArray<boolean[]> {
        }

        public static class OfDouble
        extends ForArray<double[]> {
        }

        public static class OfFloat
        extends ForArray<float[]> {
        }

        public static class OfChar
        extends ForArray<char[]> {
        }

        public static class OfLong
        extends ForArray<long[]> {
        }

        public static class OfInt
        extends ForArray<int[]> {
        }

        public static class OfShort
        extends ForArray<short[]> {
        }

        public static class OfByte
        extends ForArray<byte[]> {
        }

        public static class OfObject
        extends ForArray<Object[]> {
        }
    }
}

