/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.QpidException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerChannelMethodProcessor;
import org.apache.qpid.util.ByteBufferUtils;

public class QueueBindBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 20;
    private final int _ticket;
    private final AMQShortString _queue;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final byte _bitfield0;
    private final FieldTable _arguments;

    public QueueBindBody(int ticket, AMQShortString queue, AMQShortString exchange, AMQShortString routingKey, boolean nowait, FieldTable arguments) {
        this._ticket = ticket;
        this._queue = queue;
        this._exchange = exchange;
        this._routingKey = routingKey;
        byte bitfield0 = 0;
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
        this._arguments = arguments;
    }

    @Override
    public int getClazz() {
        return 50;
    }

    @Override
    public int getMethod() {
        return 20;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 1) != 0;
    }

    public final FieldTable getArguments() {
        return this._arguments;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._queue);
        size += this.getSizeOf(this._exchange);
        size += this.getSizeOf(this._routingKey);
        return size += this.getSizeOf(this._arguments);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeFieldTable(buffer, this._arguments);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchQueueBind(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[QueueBindBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append(", ");
        buf.append("arguments=");
        buf.append(this.getArguments());
        buf.append("]");
        return buf.toString();
    }

    public static void process(ByteBuffer buffer, ServerChannelMethodProcessor dispatcher) throws AMQFrameDecodingException {
        int ticket = ByteBufferUtils.getUnsignedShort(buffer);
        AMQShortString queue = AMQShortString.readAMQShortString(buffer);
        AMQShortString exchange = AMQShortString.readAMQShortString(buffer);
        AMQShortString bindingKey = AMQShortString.readAMQShortString(buffer);
        boolean nowait = (buffer.get() & 1) == 1;
        FieldTable arguments = EncodingUtils.readFieldTable(buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveQueueBind(queue, exchange, bindingKey, nowait, arguments);
        }
        if (arguments != null) {
            arguments.clearEncodedForm();
        }
    }
}

