/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.plugins;

import java.util.Collections;
import java.util.List;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.user.connection.limits.plugins.ConnectionLimitRule;

@ManagedObject(category=false)
public interface RuleBasedConnectionLimitProvider<X extends ConfiguredObject<X>>
extends ConfiguredObject<X> {
    @ManagedAttribute(mandatory=true, defaultValue="[ ]", description="the list of the connection limits")
    default public List<ConnectionLimitRule> getRules() {
        return Collections.emptyList();
    }

    @ManagedAttribute
    public Long getDefaultFrequencyPeriod();

    @ManagedOperation(nonModifying=true, description="Extract the connection limit rules", changesConfiguredObjectState=false)
    public Content extractRules();

    @ManagedOperation(description="Load connection limit rules from a file", changesConfiguredObjectState=true)
    public void loadFromFile(@Param(name="path", mandatory=true) String var1);

    @ManagedOperation(description="Clear all connection limits", changesConfiguredObjectState=true)
    public void clearRules();

    @ManagedOperation(nonModifying=true, description="Reset the counters of connections", changesConfiguredObjectState=false)
    public void resetCounters();
}

