/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.streams;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;

public class CompositeInputStream
extends InputStream {
    private final LinkedList<InputStream> _inputStreams;
    private InputStream _current = null;

    public CompositeInputStream(Collection<InputStream> streams) {
        if (streams == null) {
            throw new IllegalArgumentException("streams cannot be null");
        }
        this._inputStreams = new LinkedList<InputStream>(streams);
    }

    @Override
    public int read() throws IOException {
        int count = -1;
        if (this._current != null) {
            count = this._current.read();
        }
        if (count == -1 && this._inputStreams.size() > 0) {
            if (this._current != null) {
                this._current.close();
            }
            this._current = this._inputStreams.removeFirst();
            count = this.read();
        }
        return count;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = -1;
        if (this._current != null) {
            count = this._current.read(b, off, len);
        }
        if (count < len && this._inputStreams.size() > 0) {
            if (this._current != null) {
                this._current.close();
            }
            this._current = this._inputStreams.removeFirst();
            int numRead = count <= 0 ? 0 : count;
            int recursiveCount = this.read(b, off + numRead, len - numRead);
            count = recursiveCount == -1 && count == -1 ? -1 : (recursiveCount == -1 ? numRead : recursiveCount + numRead);
        }
        return count;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int available() throws IOException {
        int available = 0;
        if (this._current != null) {
            available = this._current.available();
        }
        if (this._inputStreams != null) {
            for (InputStream is : this._inputStreams) {
                if (is == null) continue;
                available += is.available();
            }
        }
        return available;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        IOException ioException = null;
        try {
            if (this._current != null) {
                try {
                    this._current.close();
                    this._current = null;
                }
                catch (IOException e) {
                    ioException = e;
                }
            }
            for (InputStream is : this._inputStreams) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    if (ioException == null) continue;
                    ioException = e;
                }
            }
        }
        finally {
            if (ioException != null) {
                throw ioException;
            }
        }
    }
}

