/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.bytebuffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.qpid.server.bytebuffer.QpidByteBufferFactory;

public interface QpidByteBuffer
extends AutoCloseable {
    public static QpidByteBuffer allocate(boolean direct, int size) {
        return QpidByteBufferFactory.allocate(direct, size);
    }

    public static QpidByteBuffer allocate(int size) {
        return QpidByteBufferFactory.allocate(size);
    }

    public static QpidByteBuffer allocateDirect(int size) {
        return QpidByteBufferFactory.allocateDirect(size);
    }

    public static QpidByteBuffer asQpidByteBuffer(InputStream stream) throws IOException {
        return QpidByteBufferFactory.asQpidByteBuffer(stream);
    }

    public static SSLEngineResult encryptSSL(SSLEngine engine, Collection<QpidByteBuffer> buffers, QpidByteBuffer dest) throws SSLException {
        return QpidByteBufferFactory.encryptSSL(engine, buffers, dest);
    }

    public static SSLEngineResult decryptSSL(SSLEngine engine, QpidByteBuffer src, QpidByteBuffer dst) throws SSLException {
        return QpidByteBufferFactory.decryptSSL(engine, src, dst);
    }

    public static QpidByteBuffer inflate(QpidByteBuffer compressedBuffer) throws IOException {
        return QpidByteBufferFactory.inflate(compressedBuffer);
    }

    public static QpidByteBuffer deflate(QpidByteBuffer uncompressedBuffer) throws IOException {
        return QpidByteBufferFactory.deflate(uncompressedBuffer);
    }

    public static long write(GatheringByteChannel channel, Collection<QpidByteBuffer> qpidByteBuffers) throws IOException {
        return QpidByteBufferFactory.write(channel, qpidByteBuffers);
    }

    public static QpidByteBuffer wrap(ByteBuffer wrap) {
        return QpidByteBufferFactory.wrap(wrap);
    }

    public static QpidByteBuffer wrap(byte[] data) {
        return QpidByteBufferFactory.wrap(data);
    }

    public static QpidByteBuffer wrap(byte[] data, int offset, int length) {
        return QpidByteBufferFactory.wrap(data, offset, length);
    }

    public static void initialisePool(int bufferSize, int maxPoolSize, double sparsityFraction) {
        QpidByteBufferFactory.initialisePool(bufferSize, maxPoolSize, sparsityFraction);
    }

    public static void deinitialisePool() {
        QpidByteBufferFactory.deinitialisePool();
    }

    public static void returnToPool(ByteBuffer buffer) {
        QpidByteBufferFactory.returnToPool(buffer);
    }

    public static int getPooledBufferSize() {
        return QpidByteBufferFactory.getPooledBufferSize();
    }

    public static long getAllocatedDirectMemorySize() {
        return QpidByteBufferFactory.getAllocatedDirectMemorySize();
    }

    public static int getNumberOfBuffersInUse() {
        return QpidByteBufferFactory.getNumberOfBuffersInUse();
    }

    public static int getNumberOfBuffersInPool() {
        return QpidByteBufferFactory.getNumberOfBuffersInPool();
    }

    public static long getPooledBufferDisposalCounter() {
        return QpidByteBufferFactory.getPooledBufferDisposalCounter();
    }

    public static QpidByteBuffer reallocateIfNecessary(QpidByteBuffer data) {
        return QpidByteBufferFactory.reallocateIfNecessary(data);
    }

    public static QpidByteBuffer concatenate(List<QpidByteBuffer> buffers) {
        return QpidByteBufferFactory.concatenate(buffers);
    }

    public static QpidByteBuffer concatenate(QpidByteBuffer ... buffers) {
        return QpidByteBufferFactory.concatenate(buffers);
    }

    public static QpidByteBuffer emptyQpidByteBuffer() {
        return QpidByteBufferFactory.emptyQpidByteBuffer();
    }

    public static ThreadFactory createQpidByteBufferTrackingThreadFactory(ThreadFactory factory) {
        return QpidByteBufferFactory.createQpidByteBufferTrackingThreadFactory(factory);
    }

    @Override
    public void close();

    public QpidByteBuffer put(int var1, byte var2);

    public QpidByteBuffer putShort(int var1, short var2);

    public QpidByteBuffer putChar(int var1, char var2);

    public QpidByteBuffer putInt(int var1, int var2);

    public QpidByteBuffer putLong(int var1, long var2);

    public QpidByteBuffer putFloat(int var1, float var2);

    public QpidByteBuffer putDouble(int var1, double var2);

    public QpidByteBuffer put(byte var1);

    public QpidByteBuffer putUnsignedByte(short var1);

    public QpidByteBuffer putShort(short var1);

    public QpidByteBuffer putUnsignedShort(int var1);

    public QpidByteBuffer putChar(char var1);

    public QpidByteBuffer putInt(int var1);

    public QpidByteBuffer putUnsignedInt(long var1);

    public QpidByteBuffer putLong(long var1);

    public QpidByteBuffer putFloat(float var1);

    public QpidByteBuffer putDouble(double var1);

    public QpidByteBuffer put(byte[] var1);

    public QpidByteBuffer put(byte[] var1, int var2, int var3);

    public QpidByteBuffer put(ByteBuffer var1);

    public QpidByteBuffer put(QpidByteBuffer var1);

    public byte get(int var1);

    public short getShort(int var1);

    public int getUnsignedShort(int var1);

    public char getChar(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public byte get();

    public short getUnsignedByte();

    public short getShort();

    public int getUnsignedShort();

    public char getChar();

    public int getInt();

    public long getUnsignedInt();

    public long getLong();

    public float getFloat();

    public double getDouble();

    public QpidByteBuffer get(byte[] var1);

    public QpidByteBuffer get(byte[] var1, int var2, int var3);

    public void copyTo(byte[] var1);

    public void copyTo(ByteBuffer var1);

    public void putCopyOf(QpidByteBuffer var1);

    public boolean isDirect();

    public void dispose();

    public InputStream asInputStream();

    public long read(ScatteringByteChannel var1) throws IOException;

    public QpidByteBuffer reset();

    public QpidByteBuffer rewind();

    public boolean hasArray();

    public byte[] array();

    public QpidByteBuffer clear();

    public QpidByteBuffer compact();

    public int position();

    public QpidByteBuffer position(int var1);

    public int limit();

    public QpidByteBuffer limit(int var1);

    public QpidByteBuffer mark();

    public int remaining();

    public boolean hasRemaining();

    public boolean hasRemaining(int var1);

    public QpidByteBuffer flip();

    public int capacity();

    public QpidByteBuffer duplicate();

    public QpidByteBuffer slice();

    public QpidByteBuffer view(int var1, int var2);

    public boolean isSparse();
}

