/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.File;
import java.io.RandomAccessFile;

public class FileCacheWarmer
extends Thread {
    private final EnvironmentImpl envImpl;
    private final long recoveryStartLsn;
    private final long endOfLogLsn;
    private final int warmUpSize;
    private final int bufSize;
    private volatile boolean stop;

    FileCacheWarmer(EnvironmentImpl envImpl, long recoveryStartLsn, long endOfLogLsn, int warmUpSize, int bufSize) {
        this.envImpl = envImpl;
        this.recoveryStartLsn = recoveryStartLsn;
        this.endOfLogLsn = endOfLogLsn;
        this.warmUpSize = warmUpSize;
        this.bufSize = bufSize;
        this.stop = false;
    }

    void shutdown() {
        this.stop = true;
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Throwable e) {
            LoggerUtils.traceAndLogException(this.envImpl, FileCacheWarmer.class.getName(), "run", "Unable to warm file system cache due to exception", e);
        }
        finally {
            this.envImpl.getFileManager().clearFileCacheWarmer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() throws Throwable {
        FileManager fm = this.envImpl.getFileManager();
        long ONE_MB = 0x100000L;
        long remaining = (long)this.warmUpSize * 0x100000L - DbLsn.getTrueDistance(this.recoveryStartLsn, this.endOfLogLsn, fm);
        if (remaining <= 0L) {
            return;
        }
        byte[] buf = new byte[this.bufSize];
        long fileNum = DbLsn.getFileNumber(this.recoveryStartLsn);
        long fileOff = DbLsn.getFileOffset(this.recoveryStartLsn);
        String filePath = fm.getFullFileName(fileNum);
        File file = new File(filePath);
        RandomAccessFile raf = null;
        this.envImpl.getCleaner().addProtectedFileRange(0L);
        try {
            raf = new RandomAccessFile(file, "r");
            while (!this.stop && remaining > 0L) {
                if (fileOff <= 0L) {
                    raf.close();
                    raf = null;
                    Long nextFileNum = fm.getFollowingFileNum(fileNum, false);
                    if (nextFileNum == null) {
                        throw new RuntimeException("No file preceding " + fileNum);
                    }
                    fileNum = nextFileNum;
                    filePath = fm.getFullFileName(fileNum);
                    file = new File(filePath);
                    raf = new RandomAccessFile(file, "r");
                    fileOff = raf.length();
                }
                long pos = Math.max(0L, fileOff - (long)this.bufSize);
                raf.seek(pos);
                int bytes = (int)(fileOff - pos);
                int read = raf.read(buf, 0, bytes);
                if (read != bytes) {
                    throw new IllegalStateException("Requested " + bytes + " bytes but read " + read);
                }
                remaining -= (long)bytes;
                fileOff = pos;
            }
            raf.close();
            raf = null;
        }
        finally {
            this.envImpl.getCleaner().removeProtectedFileRange(0L);
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

