/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.query;

import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.query.Order;

public class OrderItem<T, R> {
    private final String _alias;
    private final ExpressionNode<T, R> _expression;
    private final Order _order;

    public OrderItem(String alias, ExpressionNode<T, R> expression, Order order) {
        this._alias = alias;
        this._expression = expression;
        this._order = order;
        if (this.isAliasOrdinal() && this.getOrdinal() <= 0) {
            throw QueryParsingException.of("Order by item must be the number of a select list expression", new Object[0]);
        }
    }

    public String getAlias() {
        return this._alias != null ? this._alias : this._expression.getAlias();
    }

    public ExpressionNode<T, R> getExpression() {
        return this._expression;
    }

    public Order getOrder() {
        return this._order;
    }

    public final int getOrdinal() {
        return Integer.parseInt(this._alias);
    }

    public final boolean isAliasOrdinal() {
        return NumberConverter.isNumber(this._alias);
    }
}

