/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

/*
 * This file is auto-generated by Qpid Gentools v.0.1 - do not modify.
 * Supported AMQP version:
 *   8-0
 */

package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;

public class ConnectionSecureBody extends AMQMethodBodyImpl implements EncodableAMQDataBlock, AMQMethodBody
{

    public static final int CLASS_ID =  10;
    public static final int METHOD_ID = 20;

    // Fields declared in specification
    private final byte[] _challenge; // [challenge]


    public ConnectionSecureBody(
            byte[] challenge
                               )
    {
        _challenge = challenge;
    }

    @Override
    public int getClazz()
    {
        return CLASS_ID;
    }

    @Override
    public int getMethod()
    {
        return METHOD_ID;
    }

    public final byte[] getChallenge()
    {
        return _challenge;
    }

    @Override
    protected int getBodySize()
    {
        int size = 0;
        size += getSizeOf( _challenge );
        return size;
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer)
    {
        writeBytes( buffer, _challenge );
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException
	{
        return dispatcher.dispatchConnectionSecure(this, channelId);
	}

    @Override
    public String toString()
    {
        StringBuilder buf = new StringBuilder("[ConnectionSecureBodyImpl: ");
        buf.append( "challenge=" );
        buf.append(  getChallenge() == null  ? "null" : java.util.Arrays.toString( getChallenge() ) );
        buf.append("]");
        return buf.toString();
    }

    public static void process(final QpidByteBuffer in, final ClientMethodProcessor dispatcher)
            throws AMQFrameDecodingException

    {
        byte[] challenge = EncodingUtils.readBytes(in);
        if(!dispatcher.ignoreAllButCloseOk())
        {
            dispatcher.receiveConnectionSecure(challenge);
        }
    }
}
