/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerLayout;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.AbstractMetadataDriver;

public class PulsarLayoutManager
implements LayoutManager {
    private final MetadataStoreExtended store;
    private final String ledgersRootPath;
    private final String layoutPath;

    public PulsarLayoutManager(MetadataStoreExtended store, String ledgersRootPath) {
        this.ledgersRootPath = ledgersRootPath;
        this.store = store;
        this.layoutPath = ledgersRootPath + "/LAYOUT";
    }

    public LedgerLayout readLedgerLayout() throws IOException {
        try {
            byte[] layoutData = this.store.get(this.layoutPath).get(AbstractMetadataDriver.BLOCKING_CALL_TIMEOUT, TimeUnit.MILLISECONDS).orElseThrow(() -> new BookieException.MetadataStoreException("Layout node not found")).getValue();
            return LedgerLayout.parseLayout((byte[])layoutData);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException | TimeoutException | BookieException e) {
            throw new IOException(e);
        }
    }

    public void storeLedgerLayout(LedgerLayout ledgerLayout) throws IOException {
        try {
            byte[] layoutData = ledgerLayout.serialize();
            this.store.put(this.layoutPath, layoutData, Optional.of(-1L)).get(AbstractMetadataDriver.BLOCKING_CALL_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (TimeoutException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof MetadataStoreException.BadVersionException) {
                throw new LayoutManager.LedgerLayoutExistsException((Throwable)e);
            }
            throw new IOException(e);
        }
    }

    public void deleteLedgerLayout() throws IOException {
        try {
            this.store.delete(this.layoutPath, Optional.empty()).get(AbstractMetadataDriver.BLOCKING_CALL_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    @Generated
    MetadataStoreExtended getStore() {
        return this.store;
    }

    @Generated
    String getLedgersRootPath() {
        return this.ledgersRootPath;
    }
}

