/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication.oidc;

import com.auth0.jwt.interfaces.DecodedJWT;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import javax.naming.AuthenticationException;
import javax.net.ssl.SSLSession;
import org.apache.pulsar.broker.authentication.AuthenticationDataCommand;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.broker.authentication.oidc.AuthenticationProviderOpenID;
import org.apache.pulsar.common.api.AuthData;

class AuthenticationStateOpenID
implements AuthenticationState {
    private final AuthenticationProviderOpenID provider;
    private AuthenticationDataSource authenticationDataSource;
    private volatile String role;
    private final SocketAddress remoteAddress;
    private final SSLSession sslSession;
    private volatile long expiration;

    AuthenticationStateOpenID(AuthenticationProviderOpenID provider, SocketAddress remoteAddress, SSLSession sslSession) {
        this.provider = provider;
        this.remoteAddress = remoteAddress;
        this.sslSession = sslSession;
    }

    public String getAuthRole() throws AuthenticationException {
        if (this.role == null) {
            throw new AuthenticationException("Authentication has not completed");
        }
        return this.role;
    }

    @Deprecated
    public AuthData authenticate(AuthData authData) throws AuthenticationException {
        throw new AuthenticationException("Not supported");
    }

    public CompletableFuture<AuthData> authenticateAsync(AuthData authData) {
        String token = new String(authData.getBytes(), StandardCharsets.UTF_8);
        this.authenticationDataSource = new AuthenticationDataCommand(token, this.remoteAddress, this.sslSession);
        return this.provider.authenticateTokenAsync(this.authenticationDataSource).thenApply(jwt -> {
            this.role = this.provider.getRole((DecodedJWT)jwt);
            this.expiration = jwt.getExpiresAt().getTime();
            return null;
        });
    }

    public AuthenticationDataSource getAuthDataSource() {
        return this.authenticationDataSource;
    }

    public boolean isComplete() {
        return this.role != null;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiration;
    }
}

