/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.shard;

import io.oxia.client.shard.HashRange;
import io.oxia.proto.ShardAssignment;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public record Shard(long id, @NonNull String leader, @NonNull HashRange hashRange) {
    @Generated
    public Shard(long id, @NonNull String leader, @NonNull HashRange hashRange) {
        if (leader == null) {
            throw new NullPointerException("leader is marked non-null but is null");
        }
        if (hashRange == null) {
            throw new NullPointerException("hashRange is marked non-null but is null");
        }
    }

    public boolean overlaps(@NonNull Shard other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return this.hashRange.overlaps(other.hashRange);
    }

    @NonNull
    public Set<Shard> findOverlapping(@NonNull Collection<Shard> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return other.stream().filter(o -> !this.equals(o)).filter(this::overlaps).collect(Collectors.toSet());
    }

    @NonNull
    static Shard fromProto(@NonNull ShardAssignment s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return new Shard(s.getShard(), s.getLeader(), HashRange.fromProto(s.getInt32HashRange()));
    }
}

