/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.session;

import io.grpc.stub.StreamObserver;
import io.oxia.client.ClientConfig;
import io.oxia.client.grpc.OxiaStub;
import io.oxia.client.grpc.OxiaStubProvider;
import io.oxia.client.metrics.InstrumentProvider;
import io.oxia.client.session.Session;
import io.oxia.client.session.SessionNotificationListener;
import io.oxia.proto.CreateSessionRequest;
import io.oxia.proto.CreateSessionResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import lombok.NonNull;

public class SessionFactory {
    @NonNull
    private final ScheduledExecutorService executor;
    @NonNull
    final ClientConfig config;
    @NonNull
    final SessionNotificationListener listener;
    @NonNull
    final OxiaStubProvider stubProvider;
    @NonNull
    final InstrumentProvider instrumentProvider;

    @NonNull
    CompletableFuture<Session> create(final long shardId) {
        OxiaStub stub = this.stubProvider.getStubForShard(shardId);
        CreateSessionRequest request = CreateSessionRequest.newBuilder().setSessionTimeoutMs((int)this.config.sessionTimeout().toMillis()).setShard(shardId).setClientIdentity(this.config.clientIdentifier()).build();
        final CompletableFuture<Session> future = new CompletableFuture<Session>();
        stub.async().createSession(request, new StreamObserver<CreateSessionResponse>(){

            public void onNext(CreateSessionResponse response) {
                future.complete(new Session(SessionFactory.this.executor, SessionFactory.this.stubProvider, SessionFactory.this.config, shardId, response.getSessionId(), SessionFactory.this.instrumentProvider, SessionFactory.this.listener));
            }

            public void onError(Throwable t) {
                future.completeExceptionally(t);
            }

            public void onCompleted() {
            }
        });
        return future;
    }

    @Generated
    SessionFactory(@NonNull ScheduledExecutorService executor, @NonNull ClientConfig config, @NonNull SessionNotificationListener listener, @NonNull OxiaStubProvider stubProvider, @NonNull InstrumentProvider instrumentProvider) {
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (stubProvider == null) {
            throw new NullPointerException("stubProvider is marked non-null but is null");
        }
        if (instrumentProvider == null) {
            throw new NullPointerException("instrumentProvider is marked non-null but is null");
        }
        this.executor = executor;
        this.config = config;
        this.listener = listener;
        this.stubProvider = stubProvider;
        this.instrumentProvider = instrumentProvider;
    }
}

