/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.batch;

import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import io.oxia.client.ClientConfig;
import io.oxia.client.batch.Batch;
import io.oxia.client.batch.BatchFactory;
import io.oxia.client.batch.Operation;
import io.oxia.client.batch.ReadBatchFactory;
import io.oxia.client.batch.WriteBatchFactory;
import io.oxia.client.grpc.OxiaStubProvider;
import io.oxia.client.metrics.InstrumentProvider;
import io.oxia.client.session.SessionManager;
import io.oxia.client.util.BatchedArrayBlockingQueue;
import io.oxia.client.util.BatchedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.NonNull;

public class Batcher
implements AutoCloseable {
    private static final int DEFAULT_INITIAL_QUEUE_CAPACITY = 10000;
    @NonNull
    private final ClientConfig config;
    private final long shardId;
    @NonNull
    private final BatchFactory batchFactory;
    @NonNull
    private final BatchedBlockingQueue<Operation<?>> operations;
    private final Thread thread;

    Batcher(@NonNull ClientConfig config, long shardId, @NonNull BatchFactory batchFactory) {
        this(config, shardId, batchFactory, new BatchedArrayBlockingQueue(10000));
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (batchFactory == null) {
            throw new NullPointerException("batchFactory is marked non-null but is null");
        }
    }

    Batcher(@NonNull ClientConfig config, long shardId, @NonNull BatchFactory batchFactory, @NonNull BatchedArrayBlockingQueue<Operation<?>> operations) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (batchFactory == null) {
            throw new NullPointerException("batchFactory is marked non-null but is null");
        }
        if (operations == null) {
            throw new NullPointerException("operations is marked non-null but is null");
        }
        this.config = config;
        this.shardId = shardId;
        this.batchFactory = batchFactory;
        this.operations = operations;
        this.thread = new DefaultThreadFactory(String.format("batcher-shard-%d", shardId)).newThread(this::batcherLoop);
        this.thread.start();
    }

    public <R> void add(@NonNull Operation<R> operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        try {
            this.operations.put(operation);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public void batcherLoop() {
        Batch batch = null;
        long lingerBudgetNanos = -1L;
        Operation[] localOperations = new Operation[10000];
        int localOperationsIndex = 0;
        int localOperationsCount = 0;
        while (true) {
            try {
                if (localOperationsIndex >= localOperationsCount) {
                    if (batch == null) {
                        localOperationsCount = this.operations.takeAll(localOperations);
                    } else {
                        localOperationsCount = this.operations.pollAll(localOperations, lingerBudgetNanos, TimeUnit.NANOSECONDS);
                        long spentLingerBudgetNanos = Math.max(0L, System.nanoTime() - batch.getStartTimeNanos());
                        lingerBudgetNanos = Math.max(0L, lingerBudgetNanos - spentLingerBudgetNanos);
                    }
                    localOperationsIndex = 0;
                }
            }
            catch (InterruptedException e) {
                return;
            }
            if (localOperationsIndex < localOperationsCount) {
                if (batch == null) {
                    batch = this.batchFactory.getBatch(this.shardId);
                    lingerBudgetNanos = this.config.batchLinger().toNanos();
                }
                Operation operation = localOperations[localOperationsIndex++];
                try {
                    if (!batch.canAdd(operation)) {
                        batch.send();
                        batch = this.batchFactory.getBatch(this.shardId);
                        lingerBudgetNanos = this.config.batchLinger().toNanos();
                    }
                    batch.add(operation);
                }
                catch (Exception e) {
                    operation.fail(e);
                }
            }
            if (batch == null || batch.size() != this.config.maxRequestsPerBatch() && lingerBudgetNanos != 0L) continue;
            batch.send();
            batch = null;
        }
    }

    @NonNull
    static Function<Long, Batcher> newReadBatcherFactory(@NonNull ClientConfig config, @NonNull OxiaStubProvider stubProvider, InstrumentProvider instrumentProvider) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (stubProvider == null) {
            throw new NullPointerException("stubProvider is marked non-null but is null");
        }
        return s -> new Batcher(config, (long)s, new ReadBatchFactory(stubProvider, config, instrumentProvider));
    }

    @NonNull
    static Function<Long, Batcher> newWriteBatcherFactory(@NonNull ClientConfig config, @NonNull OxiaStubProvider stubProvider, @NonNull SessionManager sessionManager, InstrumentProvider instrumentProvider) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (stubProvider == null) {
            throw new NullPointerException("stubProvider is marked non-null but is null");
        }
        if (sessionManager == null) {
            throw new NullPointerException("sessionManager is marked non-null but is null");
        }
        return s -> new Batcher(config, (long)s, new WriteBatchFactory(stubProvider, sessionManager, config, instrumentProvider));
    }

    @Override
    public void close() {
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

