/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1SecretReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.")
public class V1RBDPersistentVolumeSource {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    private String image;
    public static final String SERIALIZED_NAME_KEYRING = "keyring";
    @SerializedName(value="keyring")
    private String keyring;
    public static final String SERIALIZED_NAME_MONITORS = "monitors";
    @SerializedName(value="monitors")
    private List<String> monitors = new ArrayList<String>();
    public static final String SERIALIZED_NAME_POOL = "pool";
    @SerializedName(value="pool")
    private String pool;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_SECRET_REF = "secretRef";
    @SerializedName(value="secretRef")
    private V1SecretReference secretRef;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private String user;

    public V1RBDPersistentVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1RBDPersistentVolumeSource image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(required=true, value="image is the rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public V1RBDPersistentVolumeSource keyring(String keyring) {
        this.keyring = keyring;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public String getKeyring() {
        return this.keyring;
    }

    public void setKeyring(String keyring) {
        this.keyring = keyring;
    }

    public V1RBDPersistentVolumeSource monitors(List<String> monitors) {
        this.monitors = monitors;
        return this;
    }

    public V1RBDPersistentVolumeSource addMonitorsItem(String monitorsItem) {
        this.monitors.add(monitorsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="monitors is a collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public List<String> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<String> monitors) {
        this.monitors = monitors;
    }

    public V1RBDPersistentVolumeSource pool(String pool) {
        this.pool = pool;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="pool is the rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public String getPool() {
        return this.pool;
    }

    public void setPool(String pool) {
        this.pool = pool;
    }

    public V1RBDPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1RBDPersistentVolumeSource secretRef(V1SecretReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(V1SecretReference secretRef) {
        this.secretRef = secretRef;
    }

    public V1RBDPersistentVolumeSource user(String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="user is the rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1RBDPersistentVolumeSource v1RBDPersistentVolumeSource = (V1RBDPersistentVolumeSource)o;
        return Objects.equals(this.fsType, v1RBDPersistentVolumeSource.fsType) && Objects.equals(this.image, v1RBDPersistentVolumeSource.image) && Objects.equals(this.keyring, v1RBDPersistentVolumeSource.keyring) && Objects.equals(this.monitors, v1RBDPersistentVolumeSource.monitors) && Objects.equals(this.pool, v1RBDPersistentVolumeSource.pool) && Objects.equals(this.readOnly, v1RBDPersistentVolumeSource.readOnly) && Objects.equals(this.secretRef, v1RBDPersistentVolumeSource.secretRef) && Objects.equals(this.user, v1RBDPersistentVolumeSource.user);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.image, this.keyring, this.monitors, this.pool, this.readOnly, this.secretRef, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1RBDPersistentVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    keyring: ").append(this.toIndentedString(this.keyring)).append("\n");
        sb.append("    monitors: ").append(this.toIndentedString(this.monitors)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

