/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZkUtils.class);

    public static void asyncCreateFullPathOptimistic(final ZooKeeper zk, final String originalPath, final byte[] data, final List<ACL> acl, final CreateMode createMode, final AsyncCallback.StringCallback callback, Object ctx) {
        zk.create(originalPath, data, acl, createMode, new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                if (rc != KeeperException.Code.NONODE.intValue()) {
                    callback.processResult(rc, path, ctx, name);
                    return;
                }
                String parent = new File(originalPath).getParent().replace("\\", "/");
                ZkUtils.asyncCreateFullPathOptimistic(zk, parent, new byte[0], acl, CreateMode.PERSISTENT, new AsyncCallback.StringCallback(){

                    public void processResult(int rc, String path, Object ctx, String name) {
                        if (rc == KeeperException.Code.OK.intValue() || rc == KeeperException.Code.NODEEXISTS.intValue()) {
                            ZkUtils.asyncCreateFullPathOptimistic(zk, originalPath, data, acl, createMode, callback, ctx);
                        } else {
                            callback.processResult(rc, path, ctx, name);
                        }
                    }
                }, ctx);
            }
        }, ctx);
    }

    public static void asyncDeleteFullPathOptimistic(final ZooKeeper zk, final String originalPath, int znodeVersion, final AsyncCallback.VoidCallback callback, final String leafNodePath) {
        zk.delete(originalPath, znodeVersion, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                if (rc == KeeperException.Code.OK.intValue()) {
                    String parent = new File(originalPath).getParent().replace("\\", "/");
                    zk.getData(parent, false, (dRc, dPath, dCtx, data, stat) -> {
                        if (KeeperException.Code.OK.intValue() == dRc && stat != null && stat.getNumChildren() == 0) {
                            ZkUtils.asyncDeleteFullPathOptimistic(zk, parent, -1, callback, leafNodePath);
                        } else {
                            callback.processResult(KeeperException.Code.OK.intValue(), path, (Object)leafNodePath);
                        }
                    }, null);
                } else if (path.equals(leafNodePath)) {
                    callback.processResult(rc, path, (Object)leafNodePath);
                } else {
                    callback.processResult(KeeperException.Code.OK.intValue(), path, (Object)leafNodePath);
                }
            }
        }, (Object)leafNodePath);
    }

    public static void createFullPathOptimistic(ZooKeeper zkc, String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger rc = new AtomicInteger(KeeperException.Code.OK.intValue());
        ZkUtils.asyncCreateFullPathOptimistic(zkc, path, data, acl, createMode, new AsyncCallback.StringCallback(){

            public void processResult(int rc2, String path, Object ctx, String name) {
                rc.set(rc2);
                latch.countDown();
            }
        }, null);
        latch.await();
        if (rc.get() != KeeperException.Code.OK.intValue()) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc.get()));
        }
    }

    public static void deleteFullPathOptimistic(ZooKeeper zkc, String path, int znodeVersion) throws KeeperException, InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger rc = new AtomicInteger(KeeperException.Code.OK.intValue());
        ZkUtils.asyncDeleteFullPathOptimistic(zkc, path, znodeVersion, new AsyncCallback.VoidCallback(){

            public void processResult(int rc2, String path, Object ctx) {
                rc.set(rc2);
                latch.countDown();
            }
        }, path);
        latch.await();
        if (rc.get() != KeeperException.Code.OK.intValue()) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getChildrenInSingleNode(ZooKeeper zk, String node, long zkOpTimeoutMs) throws InterruptedException, IOException, KeeperException.NoNodeException {
        final GetChildrenCtx ctx = new GetChildrenCtx();
        ZkUtils.getChildrenInSingleNode(zk, node, new BookkeeperInternalCallbacks.GenericCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(int rc, List<String> ledgers) {
                GetChildrenCtx getChildrenCtx = ctx;
                synchronized (getChildrenCtx) {
                    if (KeeperException.Code.OK.intValue() == rc) {
                        ctx.children = ledgers;
                    }
                    ctx.rc = rc;
                    ctx.done = true;
                    ctx.notifyAll();
                }
            }
        });
        GetChildrenCtx getChildrenCtx = ctx;
        synchronized (getChildrenCtx) {
            long startTime = System.currentTimeMillis();
            while (!ctx.done) {
                try {
                    ctx.wait(zkOpTimeoutMs > 0L ? zkOpTimeoutMs : 0L);
                }
                catch (InterruptedException e) {
                    ctx.rc = KeeperException.Code.OPERATIONTIMEOUT.intValue();
                    ctx.done = true;
                }
                if (zkOpTimeoutMs <= 0L || System.currentTimeMillis() - startTime < zkOpTimeoutMs) continue;
                ctx.rc = KeeperException.Code.OPERATIONTIMEOUT.intValue();
                ctx.done = true;
            }
        }
        if (KeeperException.Code.NONODE.intValue() == ctx.rc) {
            throw new KeeperException.NoNodeException("Got NoNode on call to getChildren on path " + node);
        }
        if (KeeperException.Code.OK.intValue() != ctx.rc) {
            throw new IOException("Error on getting children from node " + node);
        }
        return ctx.children;
    }

    public static void getChildrenInSingleNode(final ZooKeeper zk, final String node, final BookkeeperInternalCallbacks.GenericCallback<List<String>> cb) {
        zk.sync(node, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("ZK error syncing nodes when getting children: ", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    cb.operationComplete(rc, null);
                    return;
                }
                zk.getChildren(node, false, new AsyncCallback.ChildrenCallback(){

                    public void processResult(int rc, String path, Object ctx, List<String> nodes) {
                        if (rc != KeeperException.Code.OK.intValue()) {
                            LOG.error("Error polling ZK for the available nodes: ", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                            cb.operationComplete(rc, null);
                            return;
                        }
                        cb.operationComplete(rc, nodes);
                    }
                }, null);
            }
        }, null);
    }

    public static List<ACL> getACLs(AbstractConfiguration conf) {
        return conf.isZkEnableSecurity() ? ZooDefs.Ids.CREATOR_ALL_ACL : ZooDefs.Ids.OPEN_ACL_UNSAFE;
    }

    private static class GetChildrenCtx {
        int rc;
        boolean done = false;
        List<String> children = null;

        private GetChildrenCtx() {
        }
    }
}

