/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.bookie;

import com.beust.jcommander.Parameter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.UpdateLedgerOp;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateBookieInLedgerCommand
extends BookieCommand<UpdateBookieInLedgerFlags> {
    static final Logger LOG = LoggerFactory.getLogger(UpdateBookieInLedgerCommand.class);
    private static final String NAME = "update-bookie-ledger-cmd";
    private static final String DESC = "Update bookie in ledgers metadata (this may take a long time).";

    public UpdateBookieInLedgerCommand() {
        this(new UpdateBookieInLedgerFlags());
    }

    private UpdateBookieInLedgerCommand(UpdateBookieInLedgerFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, UpdateBookieInLedgerFlags cmdFlags) {
        try {
            return this.updateLedger(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean updateLedger(ServerConfiguration conf, UpdateBookieInLedgerFlags flags) throws InterruptedException, BKException, IOException {
        BookieId destBookieAddress;
        BookieId srcBookieAddress;
        try {
            String bookieAddress = flags.srcBookie;
            srcBookieAddress = BookieId.parse(bookieAddress);
            bookieAddress = flags.destBookie;
            destBookieAddress = BookieId.parse(bookieAddress);
        }
        catch (Exception e) {
            LOG.error("Bookie address must in <address>:<port> format");
            return false;
        }
        int rate = flags.updatePerSec;
        if (rate <= 0) {
            LOG.error("Invalid updatespersec {}, should be > 0", (Object)rate);
            return false;
        }
        int maxOutstandingReads = flags.maxOutstandingReads;
        if (maxOutstandingReads <= 0) {
            LOG.error("Invalid maxOutstandingReads {}, should be > 0", (Object)maxOutstandingReads);
            return false;
        }
        int limit = flags.limit;
        if (limit <= 0 && limit != Integer.MIN_VALUE) {
            LOG.error("Invalid limit {}, should be > 0", (Object)limit);
            return false;
        }
        final long printProgress = flags.verbose ? 10L : flags.printProgress;
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.addConfiguration((Configuration)conf);
        BookKeeper bk = new BookKeeper(clientConfiguration);
        BookKeeperAdmin admin = new BookKeeperAdmin(bk, clientConfiguration);
        if (admin.getAvailableBookies().contains(srcBookieAddress) || admin.getReadOnlyBookies().contains(srcBookieAddress)) {
            bk.close();
            admin.close();
            LOG.error("Source bookie {} can't be active", (Object)srcBookieAddress);
            return false;
        }
        UpdateLedgerOp updateLedgerOp = new UpdateLedgerOp(bk, admin);
        BookieShell.UpdateLedgerNotifier progressable = new BookieShell.UpdateLedgerNotifier(){
            long lastReport = System.nanoTime();

            @Override
            public void progress(long updated, long issued) {
                if (printProgress <= 0L) {
                    return;
                }
                if (TimeUnit.MILLISECONDS.toSeconds(MathUtils.elapsedMSec((long)this.lastReport)) >= printProgress) {
                    LOG.info("Number of ledgers issued={}, updated={}", (Object)issued, (Object)updated);
                    this.lastReport = MathUtils.nowInNano();
                }
            }
        };
        try {
            updateLedgerOp.updateBookieIdInLedgers(srcBookieAddress, destBookieAddress, rate, maxOutstandingReads, limit, progressable);
        }
        catch (IOException e) {
            LOG.error("Failed to update ledger metadata", (Throwable)e);
            return false;
        }
        return true;
    }

    public static class UpdateBookieInLedgerFlags
    extends CliFlags {
        @Parameter(names={"-sb", "--srcBookie"}, description="Source bookie which needs to be replaced by destination bookie. <bk-address:port>")
        private String srcBookie;
        @Parameter(names={"-db", "--destBookie"}, description="Destination bookie which replaces source bookie. <bk-address:port>")
        private String destBookie;
        @Parameter(names={"-s", "--updatepersec"}, description="Number of ledgers updating per second (default: 5 per sec)")
        private int updatePerSec = 5;
        @Parameter(names={"-r", "--maxOutstandingReads"}, description="Max outstanding reads (default: 5 * updatespersec)")
        private int maxOutstandingReads = this.updatePerSec * 5;
        @Parameter(names={"-l", "--limit"}, description="Maximum number of ledgers of ledgers to update (default: no limit)")
        private int limit = Integer.MIN_VALUE;
        @Parameter(names={"-v", "--verbose"}, description="Print status of the ledger updation (default: false)")
        private boolean verbose;
        @Parameter(names={"-p", "--printprogress"}, description="Print messages on every configured seconds if verbose turned on (default: 10 secs)")
        private long printProgress = 10L;

        public UpdateBookieInLedgerFlags srcBookie(String srcBookie) {
            this.srcBookie = srcBookie;
            return this;
        }

        public UpdateBookieInLedgerFlags destBookie(String destBookie) {
            this.destBookie = destBookie;
            return this;
        }

        public UpdateBookieInLedgerFlags updatePerSec(int updatePerSec) {
            this.updatePerSec = updatePerSec;
            return this;
        }

        public UpdateBookieInLedgerFlags maxOutstandingReads(int maxOutstandingReads) {
            this.maxOutstandingReads = maxOutstandingReads;
            return this;
        }

        public UpdateBookieInLedgerFlags limit(int limit) {
            this.limit = limit;
            return this;
        }

        public UpdateBookieInLedgerFlags verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public UpdateBookieInLedgerFlags printProgress(long printProgress) {
            this.printProgress = printProgress;
            return this;
        }
    }
}

