/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.configuration2.Configuration;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKSyncLogReader;
import org.apache.distributedlog.BKSyncLogWriter;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.exceptions.LogNotFoundException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBKSyncLogReader
extends TestDistributedLogBase {
    private static final Logger logger = LoggerFactory.getLogger(TestBKSyncLogReader.class);
    @Rule
    public TestName testName = new TestName();

    @Test(timeout=60000L)
    public void testCreateReaderBeyondLastTransactionId() throws Exception {
        String name = this.testName.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        for (long i = 1L; i < 10L; ++i) {
            LogRecord op = DLMTestUtil.getLogRecordInstance(i);
            out.write(op);
        }
        out.closeAndComplete();
        LogReader reader = dlm.getInputStream(20L);
        Assert.assertNull((Object)reader.readNext(false));
        out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        for (long i = 10L; i < 30L; ++i) {
            LogRecord op = DLMTestUtil.getLogRecordInstance(i);
            out.write(op);
        }
        out.closeAndComplete();
        for (int i = 0; i < 10; ++i) {
            LogRecord record = this.waitForNextRecord(reader);
            Assert.assertEquals((long)(20L + (long)i), (long)record.getTransactionId());
        }
        Assert.assertNull((Object)reader.readNext(false));
    }

    @Test(timeout=60000L)
    public void testDeletingLogWhileReading() throws Exception {
        LogRecord record;
        String name = this.testName.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        for (long i = 1L; i < 10L; ++i) {
            LogRecord op = DLMTestUtil.getLogRecordInstance(i);
            out.write(op);
        }
        out.closeAndComplete();
        LogReader reader = dlm.getInputStream(1L);
        for (int i = 1; i < 10; ++i) {
            record = this.waitForNextRecord(reader);
            Assert.assertEquals((long)i, (long)record.getTransactionId());
        }
        BKDistributedLogManager deleteDLM = this.createNewDLM(conf, name);
        deleteDLM.delete();
        try {
            record = reader.readNext(false);
            while (null == record) {
                record = reader.readNext(false);
            }
            Assert.fail((String)"Should fail reading next with LogNotFound");
        }
        catch (LogNotFoundException logNotFoundException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testReadingFromEmptyLog() throws Exception {
        String name = this.testName.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)conf);
        confLocal.setOutputBufferSize(0);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(Integer.MAX_VALUE);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        LogRecord op = DLMTestUtil.getLogRecordInstance(1L);
        out.write(op);
        LogReader reader = dlm.getInputStream(1L);
        Assert.assertNull((Object)reader.readNext(true));
        Assert.assertNull((Object)reader.readNext(false));
        op = DLMTestUtil.getLogRecordInstance(2L);
        out.write(op);
        LogRecord record = this.waitForNextRecord(reader);
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)1L, (long)record.getTransactionId());
        DLMTestUtil.verifyLogRecord(record);
        Assert.assertNull((Object)reader.readNext(true));
        out.close();
        reader.close();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testReadRecordsAfterReadAheadCaughtUp() throws Exception {
        String name = this.testName.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)conf);
        confLocal.setOutputBufferSize(0);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(Integer.MAX_VALUE);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        for (long i = 1L; i <= 10L; ++i) {
            LogRecord record = DLMTestUtil.getLogRecordInstance(i);
            out.write(record);
        }
        out.flush();
        out.commit();
        logger.info("Write first 10 records");
        BKSyncLogReader reader = (BKSyncLogReader)dlm.getInputStream(1L);
        while (!reader.getReadAheadReader().isReadAheadCaughtUp()) {
            TimeUnit.MILLISECONDS.sleep(20L);
        }
        logger.info("ReadAhead is caught up with first 10 records");
        for (long i = 11L; i <= 20L; ++i) {
            LogRecord record = DLMTestUtil.getLogRecordInstance(i);
            out.write(record);
        }
        out.flush();
        out.commit();
        logger.info("Write another 10 records");
        long expectedTxId = 1L;
        for (int i = 0; i < 20; ++i) {
            LogRecordWithDLSN record = reader.readNext(false);
            while (null == record) {
                record = reader.readNext(false);
            }
            Assert.assertEquals((long)expectedTxId, (long)record.getTransactionId());
            DLMTestUtil.verifyLogRecord((LogRecord)record);
            ++expectedTxId;
        }
        Assert.assertNull((Object)reader.readNext(false));
        out.close();
        reader.close();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testReadRecordsWhenReadAheadCatchingUp() throws Exception {
        String name = this.testName.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)conf);
        confLocal.setOutputBufferSize(0);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(Integer.MAX_VALUE);
        confLocal.setReadAheadMaxRecords(1);
        confLocal.setReadAheadBatchSize(1);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        for (long i = 1L; i <= 10L; ++i) {
            LogRecord record = DLMTestUtil.getLogRecordInstance(i);
            out.write(record);
        }
        out.flush();
        out.commit();
        logger.info("Write first 10 records");
        BKSyncLogReader reader = (BKSyncLogReader)dlm.getInputStream(1L);
        LogRecordWithDLSN record = reader.readNext(false);
        int numReads = 0;
        long expectedTxId = 1L;
        while (null != record) {
            ++numReads;
            Assert.assertEquals((long)expectedTxId, (long)record.getTransactionId());
            DLMTestUtil.verifyLogRecord((LogRecord)record);
            ++expectedTxId;
            record = reader.readNext(false);
        }
        Assert.assertEquals((long)10L, (long)numReads);
        out.close();
        reader.close();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testReadRecordsWhenReadAheadCatchingUp2() throws Exception {
        String name = this.testName.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)conf);
        confLocal.setOutputBufferSize(0);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(Integer.MAX_VALUE);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        final BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        for (long i = 1L; i <= 10L; ++i) {
            LogRecord record = DLMTestUtil.getLogRecordInstance(i);
            out.write(record);
        }
        out.flush();
        out.commit();
        final AtomicLong nextTxId = new AtomicLong(11L);
        logger.info("Write first 10 records");
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long txid = nextTxId.getAndIncrement();
                LogRecord record = DLMTestUtil.getLogRecordInstance(txid);
                try {
                    out.write(record);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, 0L, 400L, TimeUnit.MILLISECONDS);
        BKSyncLogReader reader = (BKSyncLogReader)dlm.getInputStream(1L);
        LogRecordWithDLSN record = reader.readNext(false);
        int numReads = 0;
        long expectedTxId = 1L;
        while (null != record) {
            ++numReads;
            Assert.assertEquals((long)expectedTxId, (long)record.getTransactionId());
            DLMTestUtil.verifyLogRecord((LogRecord)record);
            ++expectedTxId;
            record = reader.readNext(false);
        }
        Assert.assertTrue((numReads >= 10 ? 1 : 0) != 0);
        executorService.shutdown();
        out.close();
        reader.close();
        dlm.close();
    }
}

