//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.17.3
// source: InstanceCommunication.proto

package api

import (
	context "context"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type FunctionStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Running          bool   `protobuf:"varint,1,opt,name=running,proto3" json:"running,omitempty"`
	FailureException string `protobuf:"bytes,2,opt,name=failureException,proto3" json:"failureException,omitempty"`
	NumRestarts      int64  `protobuf:"varint,3,opt,name=numRestarts,proto3" json:"numRestarts,omitempty"`
	// int64 numProcessed = 4;
	NumReceived              int64                                  `protobuf:"varint,17,opt,name=numReceived,proto3" json:"numReceived,omitempty"`
	NumSuccessfullyProcessed int64                                  `protobuf:"varint,5,opt,name=numSuccessfullyProcessed,proto3" json:"numSuccessfullyProcessed,omitempty"`
	NumUserExceptions        int64                                  `protobuf:"varint,6,opt,name=numUserExceptions,proto3" json:"numUserExceptions,omitempty"`
	LatestUserExceptions     []*FunctionStatus_ExceptionInformation `protobuf:"bytes,7,rep,name=latestUserExceptions,proto3" json:"latestUserExceptions,omitempty"`
	NumSystemExceptions      int64                                  `protobuf:"varint,8,opt,name=numSystemExceptions,proto3" json:"numSystemExceptions,omitempty"`
	LatestSystemExceptions   []*FunctionStatus_ExceptionInformation `protobuf:"bytes,9,rep,name=latestSystemExceptions,proto3" json:"latestSystemExceptions,omitempty"`
	NumSourceExceptions      int64                                  `protobuf:"varint,18,opt,name=numSourceExceptions,proto3" json:"numSourceExceptions,omitempty"`
	LatestSourceExceptions   []*FunctionStatus_ExceptionInformation `protobuf:"bytes,19,rep,name=latestSourceExceptions,proto3" json:"latestSourceExceptions,omitempty"`
	NumSinkExceptions        int64                                  `protobuf:"varint,20,opt,name=numSinkExceptions,proto3" json:"numSinkExceptions,omitempty"`
	LatestSinkExceptions     []*FunctionStatus_ExceptionInformation `protobuf:"bytes,21,rep,name=latestSinkExceptions,proto3" json:"latestSinkExceptions,omitempty"`
	// map from topic name to number of deserialization exceptions
	//    map<string, int64> deserializationExceptions = 10;
	// number of serialization exceptions on the output
	//    int64 serializationExceptions = 11;
	// average latency
	AverageLatency float64 `protobuf:"fixed64,12,opt,name=averageLatency,proto3" json:"averageLatency,omitempty"`
	// When was the last time the function was invoked.
	// expressed in ms since epoch
	LastInvocationTime int64  `protobuf:"varint,13,opt,name=lastInvocationTime,proto3" json:"lastInvocationTime,omitempty"`
	InstanceId         string `protobuf:"bytes,14,opt,name=instanceId,proto3" json:"instanceId,omitempty"`
	//    MetricsData metrics = 15 [deprecated=true];
	// owner of function-instance
	WorkerId string `protobuf:"bytes,16,opt,name=workerId,proto3" json:"workerId,omitempty"`
}

func (x *FunctionStatus) Reset() {
	*x = FunctionStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_InstanceCommunication_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionStatus) ProtoMessage() {}

func (x *FunctionStatus) ProtoReflect() protoreflect.Message {
	mi := &file_InstanceCommunication_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionStatus.ProtoReflect.Descriptor instead.
func (*FunctionStatus) Descriptor() ([]byte, []int) {
	return file_InstanceCommunication_proto_rawDescGZIP(), []int{0}
}

func (x *FunctionStatus) GetRunning() bool {
	if x != nil {
		return x.Running
	}
	return false
}

func (x *FunctionStatus) GetFailureException() string {
	if x != nil {
		return x.FailureException
	}
	return ""
}

func (x *FunctionStatus) GetNumRestarts() int64 {
	if x != nil {
		return x.NumRestarts
	}
	return 0
}

func (x *FunctionStatus) GetNumReceived() int64 {
	if x != nil {
		return x.NumReceived
	}
	return 0
}

func (x *FunctionStatus) GetNumSuccessfullyProcessed() int64 {
	if x != nil {
		return x.NumSuccessfullyProcessed
	}
	return 0
}

func (x *FunctionStatus) GetNumUserExceptions() int64 {
	if x != nil {
		return x.NumUserExceptions
	}
	return 0
}

func (x *FunctionStatus) GetLatestUserExceptions() []*FunctionStatus_ExceptionInformation {
	if x != nil {
		return x.LatestUserExceptions
	}
	return nil
}

func (x *FunctionStatus) GetNumSystemExceptions() int64 {
	if x != nil {
		return x.NumSystemExceptions
	}
	return 0
}

func (x *FunctionStatus) GetLatestSystemExceptions() []*FunctionStatus_ExceptionInformation {
	if x != nil {
		return x.LatestSystemExceptions
	}
	return nil
}

func (x *FunctionStatus) GetNumSourceExceptions() int64 {
	if x != nil {
		return x.NumSourceExceptions
	}
	return 0
}

func (x *FunctionStatus) GetLatestSourceExceptions() []*FunctionStatus_ExceptionInformation {
	if x != nil {
		return x.LatestSourceExceptions
	}
	return nil
}

func (x *FunctionStatus) GetNumSinkExceptions() int64 {
	if x != nil {
		return x.NumSinkExceptions
	}
	return 0
}

func (x *FunctionStatus) GetLatestSinkExceptions() []*FunctionStatus_ExceptionInformation {
	if x != nil {
		return x.LatestSinkExceptions
	}
	return nil
}

func (x *FunctionStatus) GetAverageLatency() float64 {
	if x != nil {
		return x.AverageLatency
	}
	return 0
}

func (x *FunctionStatus) GetLastInvocationTime() int64 {
	if x != nil {
		return x.LastInvocationTime
	}
	return 0
}

func (x *FunctionStatus) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *FunctionStatus) GetWorkerId() string {
	if x != nil {
		return x.WorkerId
	}
	return ""
}

// Deprecated
type FunctionStatusList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Error              string            `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	FunctionStatusList []*FunctionStatus `protobuf:"bytes,1,rep,name=functionStatusList,proto3" json:"functionStatusList,omitempty"`
}

func (x *FunctionStatusList) Reset() {
	*x = FunctionStatusList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_InstanceCommunication_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionStatusList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionStatusList) ProtoMessage() {}

func (x *FunctionStatusList) ProtoReflect() protoreflect.Message {
	mi := &file_InstanceCommunication_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionStatusList.ProtoReflect.Descriptor instead.
func (*FunctionStatusList) Descriptor() ([]byte, []int) {
	return file_InstanceCommunication_proto_rawDescGZIP(), []int{1}
}

func (x *FunctionStatusList) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

func (x *FunctionStatusList) GetFunctionStatusList() []*FunctionStatus {
	if x != nil {
		return x.FunctionStatusList
	}
	return nil
}

type MetricsData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total number of records function received from source
	ReceivedTotal      int64 `protobuf:"varint,2,opt,name=receivedTotal,proto3" json:"receivedTotal,omitempty"`
	ReceivedTotal_1Min int64 `protobuf:"varint,10,opt,name=receivedTotal_1min,json=receivedTotal1min,proto3" json:"receivedTotal_1min,omitempty"`
	// Total number of records successfully processed by user function
	ProcessedSuccessfullyTotal      int64 `protobuf:"varint,4,opt,name=processedSuccessfullyTotal,proto3" json:"processedSuccessfullyTotal,omitempty"`
	ProcessedSuccessfullyTotal_1Min int64 `protobuf:"varint,12,opt,name=processedSuccessfullyTotal_1min,json=processedSuccessfullyTotal1min,proto3" json:"processedSuccessfullyTotal_1min,omitempty"`
	// Total number of system exceptions thrown
	SystemExceptionsTotal      int64 `protobuf:"varint,5,opt,name=systemExceptionsTotal,proto3" json:"systemExceptionsTotal,omitempty"`
	SystemExceptionsTotal_1Min int64 `protobuf:"varint,13,opt,name=systemExceptionsTotal_1min,json=systemExceptionsTotal1min,proto3" json:"systemExceptionsTotal_1min,omitempty"`
	// Total number of user exceptions thrown
	UserExceptionsTotal      int64 `protobuf:"varint,6,opt,name=userExceptionsTotal,proto3" json:"userExceptionsTotal,omitempty"`
	UserExceptionsTotal_1Min int64 `protobuf:"varint,14,opt,name=userExceptionsTotal_1min,json=userExceptionsTotal1min,proto3" json:"userExceptionsTotal_1min,omitempty"`
	// Average process latency for function
	AvgProcessLatency      float64 `protobuf:"fixed64,7,opt,name=avgProcessLatency,proto3" json:"avgProcessLatency,omitempty"`
	AvgProcessLatency_1Min float64 `protobuf:"fixed64,15,opt,name=avgProcessLatency_1min,json=avgProcessLatency1min,proto3" json:"avgProcessLatency_1min,omitempty"`
	// Timestamp of when the function was last invoked
	LastInvocation int64 `protobuf:"varint,8,opt,name=lastInvocation,proto3" json:"lastInvocation,omitempty"`
	// User defined metrics
	UserMetrics map[string]float64 `protobuf:"bytes,9,rep,name=userMetrics,proto3" json:"userMetrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
}

func (x *MetricsData) Reset() {
	*x = MetricsData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_InstanceCommunication_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricsData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricsData) ProtoMessage() {}

func (x *MetricsData) ProtoReflect() protoreflect.Message {
	mi := &file_InstanceCommunication_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricsData.ProtoReflect.Descriptor instead.
func (*MetricsData) Descriptor() ([]byte, []int) {
	return file_InstanceCommunication_proto_rawDescGZIP(), []int{2}
}

func (x *MetricsData) GetReceivedTotal() int64 {
	if x != nil {
		return x.ReceivedTotal
	}
	return 0
}

func (x *MetricsData) GetReceivedTotal_1Min() int64 {
	if x != nil {
		return x.ReceivedTotal_1Min
	}
	return 0
}

func (x *MetricsData) GetProcessedSuccessfullyTotal() int64 {
	if x != nil {
		return x.ProcessedSuccessfullyTotal
	}
	return 0
}

func (x *MetricsData) GetProcessedSuccessfullyTotal_1Min() int64 {
	if x != nil {
		return x.ProcessedSuccessfullyTotal_1Min
	}
	return 0
}

func (x *MetricsData) GetSystemExceptionsTotal() int64 {
	if x != nil {
		return x.SystemExceptionsTotal
	}
	return 0
}

func (x *MetricsData) GetSystemExceptionsTotal_1Min() int64 {
	if x != nil {
		return x.SystemExceptionsTotal_1Min
	}
	return 0
}

func (x *MetricsData) GetUserExceptionsTotal() int64 {
	if x != nil {
		return x.UserExceptionsTotal
	}
	return 0
}

func (x *MetricsData) GetUserExceptionsTotal_1Min() int64 {
	if x != nil {
		return x.UserExceptionsTotal_1Min
	}
	return 0
}

func (x *MetricsData) GetAvgProcessLatency() float64 {
	if x != nil {
		return x.AvgProcessLatency
	}
	return 0
}

func (x *MetricsData) GetAvgProcessLatency_1Min() float64 {
	if x != nil {
		return x.AvgProcessLatency_1Min
	}
	return 0
}

func (x *MetricsData) GetLastInvocation() int64 {
	if x != nil {
		return x.LastInvocation
	}
	return 0
}

func (x *MetricsData) GetUserMetrics() map[string]float64 {
	if x != nil {
		return x.UserMetrics
	}
	return nil
}

type HealthCheckResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success bool `protobuf:"varint,1,opt,name=success,proto3" json:"success,omitempty"`
}

func (x *HealthCheckResult) Reset() {
	*x = HealthCheckResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_InstanceCommunication_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheckResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheckResult) ProtoMessage() {}

func (x *HealthCheckResult) ProtoReflect() protoreflect.Message {
	mi := &file_InstanceCommunication_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheckResult.ProtoReflect.Descriptor instead.
func (*HealthCheckResult) Descriptor() ([]byte, []int) {
	return file_InstanceCommunication_proto_rawDescGZIP(), []int{3}
}

func (x *HealthCheckResult) GetSuccess() bool {
	if x != nil {
		return x.Success
	}
	return false
}

type Metrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Metrics []*Metrics_InstanceMetrics `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *Metrics) Reset() {
	*x = Metrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_InstanceCommunication_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metrics) ProtoMessage() {}

func (x *Metrics) ProtoReflect() protoreflect.Message {
	mi := &file_InstanceCommunication_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metrics.ProtoReflect.Descriptor instead.
func (*Metrics) Descriptor() ([]byte, []int) {
	return file_InstanceCommunication_proto_rawDescGZIP(), []int{4}
}

func (x *Metrics) GetMetrics() []*Metrics_InstanceMetrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

type FunctionStatus_ExceptionInformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ExceptionString string `protobuf:"bytes,1,opt,name=exceptionString,proto3" json:"exceptionString,omitempty"`
	MsSinceEpoch    int64  `protobuf:"varint,2,opt,name=msSinceEpoch,proto3" json:"msSinceEpoch,omitempty"`
}

func (x *FunctionStatus_ExceptionInformation) Reset() {
	*x = FunctionStatus_ExceptionInformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_InstanceCommunication_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionStatus_ExceptionInformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionStatus_ExceptionInformation) ProtoMessage() {}

func (x *FunctionStatus_ExceptionInformation) ProtoReflect() protoreflect.Message {
	mi := &file_InstanceCommunication_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionStatus_ExceptionInformation.ProtoReflect.Descriptor instead.
func (*FunctionStatus_ExceptionInformation) Descriptor() ([]byte, []int) {
	return file_InstanceCommunication_proto_rawDescGZIP(), []int{0, 0}
}

func (x *FunctionStatus_ExceptionInformation) GetExceptionString() string {
	if x != nil {
		return x.ExceptionString
	}
	return ""
}

func (x *FunctionStatus_ExceptionInformation) GetMsSinceEpoch() int64 {
	if x != nil {
		return x.MsSinceEpoch
	}
	return 0
}

type Metrics_InstanceMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name        string       `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	InstanceId  int32        `protobuf:"varint,2,opt,name=instanceId,proto3" json:"instanceId,omitempty"`
	MetricsData *MetricsData `protobuf:"bytes,3,opt,name=metricsData,proto3" json:"metricsData,omitempty"`
}

func (x *Metrics_InstanceMetrics) Reset() {
	*x = Metrics_InstanceMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_InstanceCommunication_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metrics_InstanceMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metrics_InstanceMetrics) ProtoMessage() {}

func (x *Metrics_InstanceMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_InstanceCommunication_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metrics_InstanceMetrics.ProtoReflect.Descriptor instead.
func (*Metrics_InstanceMetrics) Descriptor() ([]byte, []int) {
	return file_InstanceCommunication_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Metrics_InstanceMetrics) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Metrics_InstanceMetrics) GetInstanceId() int32 {
	if x != nil {
		return x.InstanceId
	}
	return 0
}

func (x *Metrics_InstanceMetrics) GetMetricsData() *MetricsData {
	if x != nil {
		return x.MetricsData
	}
	return nil
}

var File_InstanceCommunication_proto protoreflect.FileDescriptor

var file_InstanceCommunication_proto_rawDesc = []byte{
	0x0a, 0x1b, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x05, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x98, 0x08, 0x0a, 0x0e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x2a,
	0x0a, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x6e, 0x75,
	0x6d, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0b, 0x6e, 0x75, 0x6d, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x12, 0x20, 0x0a, 0x0b,
	0x6e, 0x75, 0x6d, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0b, 0x6e, 0x75, 0x6d, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x12, 0x3a,
	0x0a, 0x18, 0x6e, 0x75, 0x6d, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x6c,
	0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x18, 0x6e, 0x75, 0x6d, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x6c,
	0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x12, 0x2c, 0x0a, 0x11, 0x6e, 0x75,
	0x6d, 0x55, 0x73, 0x65, 0x72, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x6e, 0x75, 0x6d, 0x55, 0x73, 0x65, 0x72, 0x45, 0x78,
	0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5e, 0x0a, 0x14, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x45, 0x78,
	0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x14, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x78,
	0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x30, 0x0a, 0x13, 0x6e, 0x75, 0x6d, 0x53,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x6e, 0x75, 0x6d, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x62, 0x0a, 0x16, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x74, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x53, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x30,
	0x0a, 0x13, 0x6e, 0x75, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x78, 0x63, 0x65, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x6e, 0x75, 0x6d,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x62, 0x0a, 0x16, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c, 0x0a, 0x11, 0x6e, 0x75, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x45,
	0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x11, 0x6e, 0x75, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x5e, 0x0a, 0x14, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x53, 0x69, 0x6e, 0x6b,
	0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x74, 0x53, 0x69, 0x6e, 0x6b, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0e, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x61, 0x74,
	0x65, 0x6e, 0x63, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0e, 0x61, 0x76, 0x65, 0x72,
	0x61, 0x67, 0x65, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x2e, 0x0a, 0x12, 0x6c, 0x61,
	0x73, 0x74, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x6c, 0x61, 0x73, 0x74, 0x49, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x1a, 0x64, 0x0a, 0x14, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28,
	0x0a, 0x0f, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x22, 0x0a, 0x0c, 0x6d, 0x73, 0x53, 0x69,
	0x6e, 0x63, 0x65, 0x45, 0x70, 0x6f, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c,
	0x6d, 0x73, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x45, 0x70, 0x6f, 0x63, 0x68, 0x22, 0x71, 0x0a, 0x12,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4c, 0x69,
	0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x45, 0x0a, 0x12, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x12, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x22,
	0xe1, 0x05, 0x0a, 0x0b, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x12,
	0x24, 0x0a, 0x0d, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x54, 0x6f, 0x74, 0x61, 0x6c,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64,
	0x54, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65,
	0x64, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x31, 0x6d, 0x69, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x11, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x54, 0x6f, 0x74, 0x61, 0x6c,
	0x31, 0x6d, 0x69, 0x6e, 0x12, 0x3e, 0x0a, 0x1a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x64, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x54, 0x6f, 0x74,
	0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x65, 0x64, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x54,
	0x6f, 0x74, 0x61, 0x6c, 0x12, 0x47, 0x0a, 0x1f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x64, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x54, 0x6f, 0x74,
	0x61, 0x6c, 0x5f, 0x31, 0x6d, 0x69, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1e, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66,
	0x75, 0x6c, 0x6c, 0x79, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x31, 0x6d, 0x69, 0x6e, 0x12, 0x34, 0x0a,
	0x15, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x54, 0x6f,
	0x74, 0x61, 0x6c, 0x12, 0x3d, 0x0a, 0x1a, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x45, 0x78, 0x63,
	0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x31, 0x6d, 0x69,
	0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x19, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x45,
	0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x31, 0x6d,
	0x69, 0x6e, 0x12, 0x30, 0x0a, 0x13, 0x75, 0x73, 0x65, 0x72, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x13, 0x75, 0x73, 0x65, 0x72, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x54,
	0x6f, 0x74, 0x61, 0x6c, 0x12, 0x39, 0x0a, 0x18, 0x75, 0x73, 0x65, 0x72, 0x45, 0x78, 0x63, 0x65,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x31, 0x6d, 0x69, 0x6e,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x17, 0x75, 0x73, 0x65, 0x72, 0x45, 0x78, 0x63, 0x65,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x31, 0x6d, 0x69, 0x6e, 0x12,
	0x2c, 0x0a, 0x11, 0x61, 0x76, 0x67, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x61, 0x74,
	0x65, 0x6e, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x01, 0x52, 0x11, 0x61, 0x76, 0x67, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x35, 0x0a,
	0x16, 0x61, 0x76, 0x67, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x61, 0x74, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x31, 0x6d, 0x69, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x01, 0x52, 0x15, 0x61,
	0x76, 0x67, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79,
	0x31, 0x6d, 0x69, 0x6e, 0x12, 0x26, 0x0a, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x49, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x6c, 0x61,
	0x73, 0x74, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x0b,
	0x75, 0x73, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x1a, 0x3e, 0x0a, 0x10, 0x55, 0x73, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x2d, 0x0a, 0x11, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x22, 0xc0, 0x01, 0x0a, 0x07, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x38,
	0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x1a, 0x7b, 0x0a, 0x0f, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1e, 0x0a, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x34, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x32, 0xdc, 0x02, 0x0a, 0x0f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x44, 0x0a, 0x11, 0x47, 0x65, 0x74,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x15, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x00, 0x12,
	0x42, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x65, 0x74, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x12, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x22, 0x00, 0x12, 0x40, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x00, 0x12, 0x3a, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x12, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x22,
	0x00, 0x12, 0x41, 0x0a, 0x0b, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x18, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x22, 0x00, 0x42, 0x3a, 0x0a, 0x21, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x42, 0x15, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_InstanceCommunication_proto_rawDescOnce sync.Once
	file_InstanceCommunication_proto_rawDescData = file_InstanceCommunication_proto_rawDesc
)

func file_InstanceCommunication_proto_rawDescGZIP() []byte {
	file_InstanceCommunication_proto_rawDescOnce.Do(func() {
		file_InstanceCommunication_proto_rawDescData = protoimpl.X.CompressGZIP(file_InstanceCommunication_proto_rawDescData)
	})
	return file_InstanceCommunication_proto_rawDescData
}

var file_InstanceCommunication_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_InstanceCommunication_proto_goTypes = []interface{}{
	(*FunctionStatus)(nil),                      // 0: proto.FunctionStatus
	(*FunctionStatusList)(nil),                  // 1: proto.FunctionStatusList
	(*MetricsData)(nil),                         // 2: proto.MetricsData
	(*HealthCheckResult)(nil),                   // 3: proto.HealthCheckResult
	(*Metrics)(nil),                             // 4: proto.Metrics
	(*FunctionStatus_ExceptionInformation)(nil), // 5: proto.FunctionStatus.ExceptionInformation
	nil,                             // 6: proto.MetricsData.UserMetricsEntry
	(*Metrics_InstanceMetrics)(nil), // 7: proto.Metrics.InstanceMetrics
	(*emptypb.Empty)(nil),           // 8: google.protobuf.Empty
}
var file_InstanceCommunication_proto_depIdxs = []int32{
	5,  // 0: proto.FunctionStatus.latestUserExceptions:type_name -> proto.FunctionStatus.ExceptionInformation
	5,  // 1: proto.FunctionStatus.latestSystemExceptions:type_name -> proto.FunctionStatus.ExceptionInformation
	5,  // 2: proto.FunctionStatus.latestSourceExceptions:type_name -> proto.FunctionStatus.ExceptionInformation
	5,  // 3: proto.FunctionStatus.latestSinkExceptions:type_name -> proto.FunctionStatus.ExceptionInformation
	0,  // 4: proto.FunctionStatusList.functionStatusList:type_name -> proto.FunctionStatus
	6,  // 5: proto.MetricsData.userMetrics:type_name -> proto.MetricsData.UserMetricsEntry
	7,  // 6: proto.Metrics.metrics:type_name -> proto.Metrics.InstanceMetrics
	2,  // 7: proto.Metrics.InstanceMetrics.metricsData:type_name -> proto.MetricsData
	8,  // 8: proto.InstanceControl.GetFunctionStatus:input_type -> google.protobuf.Empty
	8,  // 9: proto.InstanceControl.GetAndResetMetrics:input_type -> google.protobuf.Empty
	8,  // 10: proto.InstanceControl.ResetMetrics:input_type -> google.protobuf.Empty
	8,  // 11: proto.InstanceControl.GetMetrics:input_type -> google.protobuf.Empty
	8,  // 12: proto.InstanceControl.HealthCheck:input_type -> google.protobuf.Empty
	0,  // 13: proto.InstanceControl.GetFunctionStatus:output_type -> proto.FunctionStatus
	2,  // 14: proto.InstanceControl.GetAndResetMetrics:output_type -> proto.MetricsData
	8,  // 15: proto.InstanceControl.ResetMetrics:output_type -> google.protobuf.Empty
	2,  // 16: proto.InstanceControl.GetMetrics:output_type -> proto.MetricsData
	3,  // 17: proto.InstanceControl.HealthCheck:output_type -> proto.HealthCheckResult
	13, // [13:18] is the sub-list for method output_type
	8,  // [8:13] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_InstanceCommunication_proto_init() }
func file_InstanceCommunication_proto_init() {
	if File_InstanceCommunication_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_InstanceCommunication_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_InstanceCommunication_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionStatusList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_InstanceCommunication_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricsData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_InstanceCommunication_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HealthCheckResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_InstanceCommunication_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_InstanceCommunication_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionStatus_ExceptionInformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_InstanceCommunication_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metrics_InstanceMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_InstanceCommunication_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_InstanceCommunication_proto_goTypes,
		DependencyIndexes: file_InstanceCommunication_proto_depIdxs,
		MessageInfos:      file_InstanceCommunication_proto_msgTypes,
	}.Build()
	File_InstanceCommunication_proto = out.File
	file_InstanceCommunication_proto_rawDesc = nil
	file_InstanceCommunication_proto_goTypes = nil
	file_InstanceCommunication_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// InstanceControlClient is the client API for InstanceControl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type InstanceControlClient interface {
	GetFunctionStatus(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*FunctionStatus, error)
	GetAndResetMetrics(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*MetricsData, error)
	ResetMetrics(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error)
	GetMetrics(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*MetricsData, error)
	HealthCheck(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*HealthCheckResult, error)
}

type instanceControlClient struct {
	cc grpc.ClientConnInterface
}

func NewInstanceControlClient(cc grpc.ClientConnInterface) InstanceControlClient {
	return &instanceControlClient{cc}
}

func (c *instanceControlClient) GetFunctionStatus(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*FunctionStatus, error) {
	out := new(FunctionStatus)
	err := c.cc.Invoke(ctx, "/proto.InstanceControl/GetFunctionStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceControlClient) GetAndResetMetrics(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*MetricsData, error) {
	out := new(MetricsData)
	err := c.cc.Invoke(ctx, "/proto.InstanceControl/GetAndResetMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceControlClient) ResetMetrics(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/proto.InstanceControl/ResetMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceControlClient) GetMetrics(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*MetricsData, error) {
	out := new(MetricsData)
	err := c.cc.Invoke(ctx, "/proto.InstanceControl/GetMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceControlClient) HealthCheck(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*HealthCheckResult, error) {
	out := new(HealthCheckResult)
	err := c.cc.Invoke(ctx, "/proto.InstanceControl/HealthCheck", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstanceControlServer is the server API for InstanceControl service.
type InstanceControlServer interface {
	GetFunctionStatus(context.Context, *emptypb.Empty) (*FunctionStatus, error)
	GetAndResetMetrics(context.Context, *emptypb.Empty) (*MetricsData, error)
	ResetMetrics(context.Context, *emptypb.Empty) (*emptypb.Empty, error)
	GetMetrics(context.Context, *emptypb.Empty) (*MetricsData, error)
	HealthCheck(context.Context, *emptypb.Empty) (*HealthCheckResult, error)
}

// UnimplementedInstanceControlServer can be embedded to have forward compatible implementations.
type UnimplementedInstanceControlServer struct {
}

func (*UnimplementedInstanceControlServer) GetFunctionStatus(context.Context, *emptypb.Empty) (*FunctionStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFunctionStatus not implemented")
}
func (*UnimplementedInstanceControlServer) GetAndResetMetrics(context.Context, *emptypb.Empty) (*MetricsData, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAndResetMetrics not implemented")
}
func (*UnimplementedInstanceControlServer) ResetMetrics(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetMetrics not implemented")
}
func (*UnimplementedInstanceControlServer) GetMetrics(context.Context, *emptypb.Empty) (*MetricsData, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetrics not implemented")
}
func (*UnimplementedInstanceControlServer) HealthCheck(context.Context, *emptypb.Empty) (*HealthCheckResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HealthCheck not implemented")
}

func RegisterInstanceControlServer(s *grpc.Server, srv InstanceControlServer) {
	s.RegisterService(&_InstanceControl_serviceDesc, srv)
}

func _InstanceControl_GetFunctionStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceControlServer).GetFunctionStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.InstanceControl/GetFunctionStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceControlServer).GetFunctionStatus(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceControl_GetAndResetMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceControlServer).GetAndResetMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.InstanceControl/GetAndResetMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceControlServer).GetAndResetMetrics(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceControl_ResetMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceControlServer).ResetMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.InstanceControl/ResetMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceControlServer).ResetMetrics(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceControl_GetMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceControlServer).GetMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.InstanceControl/GetMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceControlServer).GetMetrics(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceControl_HealthCheck_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceControlServer).HealthCheck(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.InstanceControl/HealthCheck",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceControlServer).HealthCheck(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _InstanceControl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "proto.InstanceControl",
	HandlerType: (*InstanceControlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetFunctionStatus",
			Handler:    _InstanceControl_GetFunctionStatus_Handler,
		},
		{
			MethodName: "GetAndResetMetrics",
			Handler:    _InstanceControl_GetAndResetMetrics_Handler,
		},
		{
			MethodName: "ResetMetrics",
			Handler:    _InstanceControl_ResetMetrics_Handler,
		},
		{
			MethodName: "GetMetrics",
			Handler:    _InstanceControl_GetMetrics_Handler,
		},
		{
			MethodName: "HealthCheck",
			Handler:    _InstanceControl_HealthCheck_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "InstanceCommunication.proto",
}
