/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

class PulsarPerfTestPropertiesProvider
extends CommandLine.PropertiesDefaultProvider {
    private static final String brokerServiceUrlKey = "brokerServiceUrl";
    private static final String webServiceUrlKey = "webServiceUrl";
    private final Properties properties;

    public PulsarPerfTestPropertiesProvider(Properties properties) {
        super(properties);
        this.properties = properties;
    }

    static PulsarPerfTestPropertiesProvider create(Properties properties) {
        if (StringUtils.isBlank((CharSequence)properties.getProperty(brokerServiceUrlKey))) {
            String webServiceUrl = properties.getProperty(webServiceUrlKey);
            if (StringUtils.isNotBlank((CharSequence)webServiceUrl)) {
                properties.put(brokerServiceUrlKey, webServiceUrl);
            } else if (StringUtils.isNotBlank((CharSequence)properties.getProperty("serviceUrl"))) {
                properties.put(brokerServiceUrlKey, properties.getProperty("serviceUrl", "http://localhost:8080/"));
            }
        }
        if (StringUtils.isBlank((CharSequence)properties.getProperty(webServiceUrlKey))) {
            properties.put(webServiceUrlKey, properties.getProperty("adminURL", "http://localhost:8080/"));
        }
        return new PulsarPerfTestPropertiesProvider(properties);
    }
}

