/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cluster;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.common.conf.ConfigurationUtil;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.stream.cluster.StreamCluster;
import org.apache.bookkeeper.stream.cluster.StreamClusterSpec;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneStarter {
    private static final Logger log = LoggerFactory.getLogger(StandaloneStarter.class);

    public static void main(String[] args) throws Exception {
        int retCode = StandaloneStarter.doMain(args);
        Runtime.getRuntime().exit(retCode);
    }

    static int doMain(String[] args) throws Exception {
        StarterArgs starterArgs = new StarterArgs();
        JCommander commander = new JCommander();
        try {
            commander.setProgramName("standalone-starter");
            commander.addObject((Object)starterArgs);
            commander.parse(args);
            if (starterArgs.help) {
                commander.usage();
                return 0;
            }
        }
        catch (Exception e) {
            commander.usage();
            return -1;
        }
        StreamClusterSpec.StreamClusterSpecBuilder specBuilder = StreamClusterSpec.builder();
        if (starterArgs.metadataServiceUri == null) {
            specBuilder = specBuilder.zkPort(starterArgs.zkPort).shouldStartZooKeeper(true);
        } else {
            ServiceURI serviceURI = ServiceURI.create((String)starterArgs.metadataServiceUri);
            specBuilder = specBuilder.metadataServiceUri(serviceURI).shouldStartZooKeeper(false);
        }
        CompositeConfiguration conf = new CompositeConfiguration();
        if (null != starterArgs.configFile) {
            PropertiesConfiguration propsConf = ConfigurationUtil.newConfiguration(c -> c.propertiesBuilder(starterArgs.configFile));
            conf.addConfiguration((Configuration)propsConf);
        }
        Preconditions.checkArgument((starterArgs.numBookies > 0 ? 1 : 0) != 0, (Object)("Invalid number of bookies : " + starterArgs.numBookies));
        if (starterArgs.numBookies == 1) {
            conf.setProperty("dlog.bkcEnsembleSize", (Object)1);
            conf.setProperty("dlog.bkcWriteQuorumSize", (Object)1);
            conf.setProperty("dlog.bkcAckQuorumSize", (Object)1);
        } else {
            conf.setProperty("dlog.bkcEnsembleSize", (Object)starterArgs.numBookies);
            conf.setProperty("dlog.bkcWriteQuorumSize", (Object)starterArgs.numBookies);
            conf.setProperty("dlog.bkcAckQuorumSize", (Object)(starterArgs.numBookies - 1));
        }
        StreamClusterSpec spec = specBuilder.baseConf(conf).numServers(starterArgs.numBookies).initialBookiePort(starterArgs.initialBookiePort).initialGrpcPort(starterArgs.initialBookieGrpcPort).storageRootDir(new File(starterArgs.dataDir)).build();
        CountDownLatch liveLatch = new CountDownLatch(1);
        StreamCluster cluster = StreamCluster.build(spec);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            cluster.stop();
            cluster.close();
            liveLatch.countDown();
        }, "Standalone-Shutdown-Thread"));
        cluster.start();
        try {
            liveLatch.await();
        }
        catch (InterruptedException e) {
            log.error("The standalone cluster is interrupted : ", (Throwable)e);
        }
        return 0;
    }

    private static class StarterArgs {
        @Parameter(names={"-c", "--conf"}, description="Configuration file path")
        String configFile = null;
        @Parameter(names={"--num-bookies"}, description="Num of bookies")
        int numBookies = 1;
        @Parameter(names={"--zk-port"}, description="ZooKeeper port")
        int zkPort = 2181;
        @Parameter(names={"-u", "--metadata-service-uri"}, description="Uri of the external metadata service. If set, the standalone will not start any metadata service itself.")
        String metadataServiceUri = null;
        @Parameter(names={"--initial-bookie-port"}, description="Initial bookie port")
        int initialBookiePort = 3181;
        @Parameter(names={"--initial-bookie-grpc-port"}, description="Initial bookie grpc port")
        int initialBookieGrpcPort = 4181;
        @Parameter(names={"--data-dir"}, description="Location to store standalone data")
        String dataDir = "data";
        @Parameter(names={"--wipe-data"}, description="Clean up previous standalone data")
        boolean wipeData = false;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        boolean help = false;

        private StarterArgs() {
        }
    }
}

