/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.util.function.ToIntFunction;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.protocol.Commands;
import org.jspecify.annotations.Nullable;

public class EntryAndMetadata
implements Entry {
    private static final int STICKY_KEY_HASH_NOT_INITIALIZED = -1;
    private final Entry entry;
    private final @Nullable MessageMetadata metadata;
    int stickyKeyHash = -1;

    private EntryAndMetadata(Entry entry, @Nullable MessageMetadata metadata) {
        this.entry = entry;
        this.metadata = metadata;
    }

    public static EntryAndMetadata create(Entry entry, MessageMetadata metadata) {
        return new EntryAndMetadata(entry, metadata);
    }

    @VisibleForTesting
    public static EntryAndMetadata create(Entry entry) {
        return EntryAndMetadata.create(entry, Commands.peekAndCopyMessageMetadata((ByteBuf)entry.getDataBuffer(), (String)"", (long)-1L));
    }

    public byte[] getStickyKey() {
        if (this.metadata != null) {
            return Commands.resolveStickyKey((MessageMetadata)this.metadata);
        }
        return Commands.NONE_KEY;
    }

    public String toString() {
        String s = this.entry.getLedgerId() + ":" + this.entry.getEntryId();
        if (this.metadata != null) {
            s = s + "@" + this.metadata.getProducerName() + "-" + this.metadata.getSequenceId();
            if (this.metadata.hasChunkId() && this.metadata.hasNumChunksFromMsg()) {
                s = s + "-" + this.metadata.getChunkId() + "-" + this.metadata.getNumChunksFromMsg();
            }
        }
        return s;
    }

    public byte[] getData() {
        return this.entry.getData();
    }

    public byte[] getDataAndRelease() {
        return this.entry.getDataAndRelease();
    }

    public int getLength() {
        return this.entry.getLength();
    }

    public ByteBuf getDataBuffer() {
        return this.entry.getDataBuffer();
    }

    public Position getPosition() {
        return this.entry.getPosition();
    }

    public long getLedgerId() {
        return this.entry.getLedgerId();
    }

    public long getEntryId() {
        return this.entry.getEntryId();
    }

    public boolean release() {
        return this.entry.release();
    }

    public int getOrUpdateCachedStickyKeyHash(ToIntFunction<byte[]> makeStickyKeyHash) {
        if (this.stickyKeyHash == -1) {
            this.stickyKeyHash = makeStickyKeyHash.applyAsInt(this.getStickyKey());
        }
        return this.stickyKeyHash;
    }

    public int getCachedStickyKeyHash() {
        return this.stickyKeyHash != -1 ? this.stickyKeyHash : 0;
    }

    @VisibleForTesting
    public Entry unwrap() {
        return this.entry;
    }

    @Generated
    public @Nullable MessageMetadata getMetadata() {
        return this.metadata;
    }
}

