/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1CSINodeDriver;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="CSINodeSpec holds information about the specification of all CSI drivers installed on a node")
public class V1CSINodeSpec {
    public static final String SERIALIZED_NAME_DRIVERS = "drivers";
    @SerializedName(value="drivers")
    private List<V1CSINodeDriver> drivers = new ArrayList<V1CSINodeDriver>();

    public V1CSINodeSpec drivers(List<V1CSINodeDriver> drivers) {
        this.drivers = drivers;
        return this;
    }

    public V1CSINodeSpec addDriversItem(V1CSINodeDriver driversItem) {
        this.drivers.add(driversItem);
        return this;
    }

    @ApiModelProperty(required=true, value="drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are uninstalled, this can become empty.")
    public List<V1CSINodeDriver> getDrivers() {
        return this.drivers;
    }

    public void setDrivers(List<V1CSINodeDriver> drivers) {
        this.drivers = drivers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CSINodeSpec v1CSINodeSpec = (V1CSINodeSpec)o;
        return Objects.equals(this.drivers, v1CSINodeSpec.drivers);
    }

    public int hashCode() {
        return Objects.hash(this.drivers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CSINodeSpec {\n");
        sb.append("    drivers: ").append(this.toIndentedString(this.drivers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

