/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.batch;

import io.opentelemetry.api.common.Attributes;
import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.batch.Batch;
import io.streamnative.oxia.client.batch.BatchFactory;
import io.streamnative.oxia.client.batch.ReadBatch;
import io.streamnative.oxia.client.grpc.OxiaStubProvider;
import io.streamnative.oxia.client.metrics.InstrumentProvider;
import io.streamnative.oxia.client.metrics.LatencyHistogram;
import lombok.NonNull;

class ReadBatchFactory
extends BatchFactory {
    private final LatencyHistogram readRequestLatencyHistogram;

    public ReadBatchFactory(@NonNull OxiaStubProvider stubProvider, @NonNull ClientConfig config, @NonNull InstrumentProvider instrumentProvider) {
        super(stubProvider, config);
        if (stubProvider == null) {
            throw new NullPointerException("stubProvider is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (instrumentProvider == null) {
            throw new NullPointerException("instrumentProvider is marked non-null but is null");
        }
        this.readRequestLatencyHistogram = instrumentProvider.newLatencyHistogram("oxia.client.ops.req", "The latency of a get batch request to the server", Attributes.builder().put("oxia.batch.type", "read").build());
    }

    @Override
    public Batch getBatch(long shardId) {
        return new ReadBatch(this, this.stubProvider, shardId);
    }

    public LatencyHistogram getReadRequestLatencyHistogram() {
        return this.readRequestLatencyHistogram;
    }
}

