/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.batch;

import io.streamnative.oxia.client.grpc.OxiaStub;
import io.streamnative.oxia.client.grpc.OxiaStubProvider;
import io.streamnative.oxia.client.grpc.WriteStreamWrapper;
import lombok.NonNull;

abstract class BatchBase {
    @NonNull
    private final OxiaStubProvider stubProvider;
    private final long shardId;
    private final long startTimeNanos = System.nanoTime();

    BatchBase(OxiaStubProvider stubProvider, long shardId) {
        this.stubProvider = stubProvider;
        this.shardId = shardId;
    }

    protected OxiaStub getStub() {
        return this.stubProvider.getStubForShard(this.shardId);
    }

    protected WriteStreamWrapper getWriteStream() {
        return this.stubProvider.getWriteStreamForShard(this.shardId);
    }

    public long getShardId() {
        return this.shardId;
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }
}

