/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.")
public class V1StatefulSetPersistentVolumeClaimRetentionPolicy {
    public static final String SERIALIZED_NAME_WHEN_DELETED = "whenDeleted";
    @SerializedName(value="whenDeleted")
    private String whenDeleted;
    public static final String SERIALIZED_NAME_WHEN_SCALED = "whenScaled";
    @SerializedName(value="whenScaled")
    private String whenScaled;

    public V1StatefulSetPersistentVolumeClaimRetentionPolicy whenDeleted(String whenDeleted) {
        this.whenDeleted = whenDeleted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.")
    public String getWhenDeleted() {
        return this.whenDeleted;
    }

    public void setWhenDeleted(String whenDeleted) {
        this.whenDeleted = whenDeleted;
    }

    public V1StatefulSetPersistentVolumeClaimRetentionPolicy whenScaled(String whenScaled) {
        this.whenScaled = whenScaled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.")
    public String getWhenScaled() {
        return this.whenScaled;
    }

    public void setWhenScaled(String whenScaled) {
        this.whenScaled = whenScaled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StatefulSetPersistentVolumeClaimRetentionPolicy v1StatefulSetPersistentVolumeClaimRetentionPolicy = (V1StatefulSetPersistentVolumeClaimRetentionPolicy)o;
        return Objects.equals(this.whenDeleted, v1StatefulSetPersistentVolumeClaimRetentionPolicy.whenDeleted) && Objects.equals(this.whenScaled, v1StatefulSetPersistentVolumeClaimRetentionPolicy.whenScaled);
    }

    public int hashCode() {
        return Objects.hash(this.whenDeleted, this.whenScaled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1StatefulSetPersistentVolumeClaimRetentionPolicy {\n");
        sb.append("    whenDeleted: ").append(this.toIndentedString(this.whenDeleted)).append("\n");
        sb.append("    whenScaled: ").append(this.toIndentedString(this.whenScaled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

