/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.KeyStoreParams;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.AuthenticationUtil;
import org.apache.pulsar.client.impl.auth.AuthenticationDataKeyStoreTls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationKeyStoreTls
implements Authentication,
EncodedAuthenticationParameterSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticationKeyStoreTls.class);
    private static final long serialVersionUID = 1L;
    private static final String AUTH_NAME = "tls";
    public static final String KEYSTORE_TYPE = "keyStoreType";
    public static final String KEYSTORE_PATH = "keyStorePath";
    public static final String KEYSTORE_PW = "keyStorePassword";
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private transient KeyStoreParams keyStoreParams;

    public AuthenticationKeyStoreTls() {
    }

    public AuthenticationKeyStoreTls(String keyStoreType, String keyStorePath, String keyStorePassword) {
        this.keyStoreParams = KeyStoreParams.builder().keyStoreType(keyStoreType).keyStorePath(keyStorePath).keyStorePassword(keyStorePassword).build();
    }

    public void close() throws IOException {
    }

    public String getAuthMethodName() {
        return AUTH_NAME;
    }

    public AuthenticationDataProvider getAuthData() throws PulsarClientException {
        try {
            return new AuthenticationDataKeyStoreTls(this.keyStoreParams);
        }
        catch (Exception e) {
            throw new PulsarClientException((Throwable)e);
        }
    }

    public void configure(String paramsString) {
        Map<String, String> params = null;
        try {
            params = AuthenticationUtil.configureFromJsonString(paramsString);
        }
        catch (Exception e) {
            log.info("parameter not in Json format: {}", (Object)paramsString);
        }
        params = params == null || params.isEmpty() ? AuthenticationUtil.configureFromPulsar1AuthParamString(paramsString) : params;
        this.configure(params);
    }

    public void configure(Map<String, String> params) {
        String keyStoreType = params.get(KEYSTORE_TYPE);
        String keyStorePath = params.get(KEYSTORE_PATH);
        String keyStorePassword = params.get(KEYSTORE_PW);
        if (Strings.isNullOrEmpty((String)keyStorePath) || Strings.isNullOrEmpty((String)keyStorePassword)) {
            throw new IllegalArgumentException("Passed in parameter empty. keyStorePath: " + keyStorePath + " " + KEYSTORE_PW + ": " + keyStorePassword);
        }
        if (Strings.isNullOrEmpty((String)keyStoreType)) {
            keyStoreType = DEFAULT_KEYSTORE_TYPE;
        }
        this.keyStoreParams = KeyStoreParams.builder().keyStoreType(keyStoreType).keyStorePath(keyStorePath).keyStorePassword(keyStorePassword).build();
    }

    public void start() throws PulsarClientException {
    }

    public static String mapToString(Map<String, String> map) {
        return Joiner.on((char)',').withKeyValueSeparator(':').join(map);
    }
}

