/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.sql.planner.plan.ChildReplacer;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.List;

public abstract class SimplePlanRewriter<C>
extends PlanVisitor<PlanNode, RewriteContext<C>> {
    public static <C> PlanNode rewriteWith(SimplePlanRewriter<C> rewriter, PlanNode node) {
        return (PlanNode)node.accept(rewriter, new RewriteContext<Object>(rewriter, null));
    }

    public static <C> PlanNode rewriteWith(SimplePlanRewriter<C> rewriter, PlanNode node, C context) {
        return (PlanNode)node.accept(rewriter, new RewriteContext<C>(rewriter, context));
    }

    @Override
    protected PlanNode visitPlan(PlanNode node, RewriteContext<C> context) {
        return context.defaultRewrite(node, context.get());
    }

    public static class RewriteContext<C> {
        private final C userContext;
        private final SimplePlanRewriter<C> nodeRewriter;

        private RewriteContext(SimplePlanRewriter<C> nodeRewriter, C userContext) {
            this.nodeRewriter = nodeRewriter;
            this.userContext = userContext;
        }

        public C get() {
            return this.userContext;
        }

        public PlanNode defaultRewrite(PlanNode node) {
            return this.defaultRewrite(node, null);
        }

        public PlanNode defaultRewrite(PlanNode node, C context) {
            List children = (List)node.getSources().stream().map(child -> this.rewrite((PlanNode)child, context)).collect(ImmutableList.toImmutableList());
            return ChildReplacer.replaceChildren(node, children);
        }

        public PlanNode rewrite(PlanNode node, C userContext) {
            PlanNode result = (PlanNode)node.accept(this.nodeRewriter, new RewriteContext<C>(this.nodeRewriter, userContext));
            return (PlanNode)Verify.verifyNotNull((Object)result, (String)"nodeRewriter returned null for %s", (Object[])new Object[]{node.getClass().getName()});
        }

        public PlanNode rewrite(PlanNode node) {
            return this.rewrite(node, null);
        }
    }
}

