/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.DateTimes;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampToVarcharCast {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss");

    private TimestampToVarcharCast() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p)") long epochMicros) {
        return Slices.utf8Slice((String)DateTimes.formatTimestamp((int)precision, epochMicros, 0, ZoneOffset.UTC, TIMESTAMP_FORMATTER));
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return Slices.utf8Slice((String)DateTimes.formatTimestamp((int)precision, timestamp.getEpochMicros(), timestamp.getPicosOfMicro(), ZoneOffset.UTC, TIMESTAMP_FORMATTER));
    }
}

