/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.TypeSignature;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class AggregationFunctionMetadata {
    private final boolean orderSensitive;
    private final List<TypeSignature> intermediateTypes;

    public AggregationFunctionMetadata(boolean orderSensitive, TypeSignature ... intermediateTypes) {
        this(orderSensitive, (List<TypeSignature>)ImmutableList.copyOf((Object[])Objects.requireNonNull(intermediateTypes, "intermediateTypes is null")));
    }

    public AggregationFunctionMetadata(boolean orderSensitive, List<TypeSignature> intermediateTypes) {
        this.orderSensitive = orderSensitive;
        this.intermediateTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(intermediateTypes, "intermediateTypes is null"));
    }

    public boolean isOrderSensitive() {
        return this.orderSensitive;
    }

    public boolean isDecomposable() {
        return !this.intermediateTypes.isEmpty();
    }

    public List<TypeSignature> getIntermediateTypes() {
        return this.intermediateTypes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orderSensitive", this.orderSensitive).add("intermediateTypes", this.intermediateTypes).toString();
    }
}

