/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class TopologyAwareNodeSelectorConfig {
    private TopologyType type = TopologyType.FLAT;
    private List<String> locationSegmentNames = ImmutableList.of((Object)"machine");

    @NotNull
    public TopologyType getType() {
        return this.type;
    }

    @Config(value="node-scheduler.network-topology.type")
    public TopologyAwareNodeSelectorConfig setType(TopologyType type) {
        this.type = type;
        return this;
    }

    @NotNull
    public List<String> getLocationSegmentNames() {
        return this.locationSegmentNames;
    }

    public TopologyAwareNodeSelectorConfig setLocationSegmentNames(List<String> locationSegmentNames) {
        this.locationSegmentNames = Objects.requireNonNull(locationSegmentNames, "locationSegmentNames is null");
        return this;
    }

    @Config(value="node-scheduler.network-topology.segments")
    public TopologyAwareNodeSelectorConfig setLocationSegmentNames(String locationSegmentNames) {
        this.locationSegmentNames = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)locationSegmentNames);
        return this;
    }

    public static enum TopologyType {
        FLAT,
        FILE,
        SUBNET;

    }
}

