/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHandlerFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHandlerFilter.class);
    private static final String BROKER_ADDRESS_HEADER_NAME = "broker-address";
    private final String brokerAddress;
    private final BrokerInterceptor interceptor;

    public ResponseHandlerFilter(PulsarService pulsar) {
        this.brokerAddress = pulsar.getAdvertisedAddress();
        this.interceptor = Objects.requireNonNull(pulsar.getBrokerInterceptor());
    }

    public void doFilter(final ServletRequest request, final ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!response.isCommitted()) {
            ((HttpServletResponse)response).addHeader(BROKER_ADDRESS_HEADER_NAME, this.brokerAddress);
        } else {
            LOG.warn("Cannot add header {} to request {} since it's already committed.", (Object)BROKER_ADDRESS_HEADER_NAME, (Object)request);
        }
        chain.doFilter(request, response);
        if (((HttpServletResponse)response).getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            try {
                ((HttpServletRequest)request).getSession(false).invalidate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (request.isAsyncSupported() && request.isAsyncStarted()) {
            request.getAsyncContext().addListener(new AsyncListener(){

                public void onComplete(AsyncEvent asyncEvent) throws IOException {
                    ResponseHandlerFilter.this.handleInterceptor(request, response);
                }

                public void onTimeout(AsyncEvent asyncEvent) throws IOException {
                    LOG.warn("Http request {} async context timeout.", (Object)request);
                    ResponseHandlerFilter.this.handleInterceptor(request, response);
                }

                public void onError(AsyncEvent asyncEvent) throws IOException {
                    LOG.warn("Http request {} async context error.", (Object)request, (Object)asyncEvent.getThrowable());
                    ResponseHandlerFilter.this.handleInterceptor(request, response);
                }

                public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
                }
            });
        } else {
            this.handleInterceptor(request, response);
        }
    }

    private void handleInterceptor(ServletRequest request, ServletResponse response) {
        if (!StringUtils.containsIgnoreCase((CharSequence)request.getContentType(), (CharSequence)"multipart/form-data") && !StringUtils.containsIgnoreCase((CharSequence)request.getContentType(), (CharSequence)"application/octet-stream")) {
            try {
                this.interceptor.onWebserviceResponse(request, response);
            }
            catch (Exception e) {
                LOG.error("Failed to handle interceptor on web service response.", (Throwable)e);
            }
        }
    }

    public void init(FilterConfig arg) throws ServletException {
    }

    public void destroy() {
    }
}

