/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.sql.tree.QualifiedName;
import io.trino.type.DateTimes;
import io.trino.type.JsonType;
import io.trino.type.UnknownType;
import io.trino.util.Failures;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.function.BiFunction;

public final class FormatFunction
extends SqlScalarFunction {
    public static final String NAME = "$format";
    public static final FormatFunction FORMAT_FUNCTION = new FormatFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(FormatFunction.class, "sqlFormat", List.class, ConnectorSession.class, Slice.class, Block.class);

    private FormatFunction() {
        super(new FunctionMetadata(Signature.builder().name(NAME).typeVariableConstraints(Signature.withVariadicBound("T", "row")).argumentTypes(VarcharType.VARCHAR.getTypeSignature(), new TypeSignature("T", new TypeSignatureParameter[0])).returnType(VarcharType.VARCHAR.getTypeSignature()).build(), new FunctionNullability(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false)), true, true, "formats the input arguments using a format string", FunctionKind.SCALAR));
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies(BoundSignature boundSignature) {
        FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder = FunctionDependencyDeclaration.builder();
        boundSignature.getArgumentTypes().get(1).getTypeParameters().forEach(type -> FormatFunction.addDependencies(builder, type));
        return builder.build();
    }

    private static void addDependencies(FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder, Type type) {
        if (type.equals((Object)UnknownType.UNKNOWN) || type.equals(BooleanType.BOOLEAN) || type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT) || type.equals(RealType.REAL) || type.equals(DoubleType.DOUBLE) || type.equals(DateType.DATE) || type instanceof TimestampWithTimeZoneType || type instanceof TimestampType || type instanceof TimeType || Decimals.isShortDecimal((Type)type) || Decimals.isLongDecimal((Type)type) || type instanceof VarcharType || type instanceof CharType) {
            return;
        }
        if (type.equals((Object)JsonType.JSON)) {
            builder.addFunction(QualifiedName.of((String)"json_format"), (List<Type>)ImmutableList.of((Object)((Object)JsonType.JSON)));
            return;
        }
        builder.addCast(type, (Type)VarcharType.VARCHAR);
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        Type rowType = boundSignature.getArgumentType(1);
        List converters = (List)Streams.mapWithIndex(rowType.getTypeParameters().stream(), (type, index) -> FormatFunction.converter(functionDependencies, type, Math.toIntExact(index))).collect(ImmutableList.toImmutableList());
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), METHOD_HANDLE.bindTo(converters));
    }

    @UsedByGeneratedCode
    public static Slice sqlFormat(List<BiFunction<ConnectorSession, Block, Object>> converters, ConnectorSession session, Slice slice, Block row) {
        Object[] args = new Object[converters.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = converters.get(i).apply(session, row);
        }
        return FormatFunction.sqlFormat(session, slice.toStringUtf8(), args);
    }

    private static Slice sqlFormat(ConnectorSession session, String format, Object[] args) {
        try {
            return Slices.utf8Slice((String)String.format(session.getLocale(), format, args));
        }
        catch (IllegalFormatException e) {
            String message = e.toString().replaceFirst("^java\\.util\\.(\\w+)Exception", "$1");
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Invalid format string: %s (%s)", format, message), (Throwable)e);
        }
    }

    private static BiFunction<ConnectorSession, Block, Object> converter(FunctionDependencies functionDependencies, Type type, int position) {
        BiFunction<ConnectorSession, Block, Object> converter = FormatFunction.valueConverter(functionDependencies, type, position);
        return (session, block) -> block.isNull(position) ? null : converter.apply((ConnectorSession)session, (Block)block);
    }

    private static BiFunction<ConnectorSession, Block, Object> valueConverter(FunctionDependencies functionDependencies, Type type, int position) {
        if (type.equals((Object)UnknownType.UNKNOWN)) {
            return (session, block) -> null;
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return (session, block) -> type.getBoolean(block, position);
        }
        if (type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT)) {
            return (session, block) -> type.getLong(block, position);
        }
        if (type.equals(RealType.REAL)) {
            return (session, block) -> Float.valueOf(Float.intBitsToFloat(Math.toIntExact(type.getLong(block, position))));
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return (session, block) -> type.getDouble(block, position);
        }
        if (type.equals(DateType.DATE)) {
            return (session, block) -> LocalDate.ofEpochDay(type.getLong(block, position));
        }
        if (type instanceof TimestampWithTimeZoneType) {
            return (session, block) -> DateTimes.toZonedDateTime((TimestampWithTimeZoneType)type, block, position);
        }
        if (type instanceof TimestampType) {
            return (session, block) -> DateTimes.toLocalDateTime((TimestampType)type, block, position);
        }
        if (type instanceof TimeType) {
            return (session, block) -> FormatFunction.toLocalTime(type.getLong(block, position));
        }
        if (type.equals((Object)JsonType.JSON)) {
            MethodHandle handle = functionDependencies.getFunctionInvoker(QualifiedName.of((String)"json_format"), (List<Type>)ImmutableList.of((Object)((Object)JsonType.JSON)), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle();
            return (session, block) -> FormatFunction.convertToString(handle, type.getSlice(block, position));
        }
        if (Decimals.isShortDecimal((Type)type)) {
            int scale = ((DecimalType)type).getScale();
            return (session, block) -> BigDecimal.valueOf(type.getLong(block, position), scale);
        }
        if (Decimals.isLongDecimal((Type)type)) {
            int scale = ((DecimalType)type).getScale();
            return (session, block) -> new BigDecimal(((Int128)type.getObject(block, position)).toBigInteger(), scale);
        }
        if (type instanceof VarcharType) {
            return (session, block) -> type.getSlice(block, position).toStringUtf8();
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return (session, block) -> Chars.padSpaces((Slice)type.getSlice(block, position), (CharType)charType).toStringUtf8();
        }
        BiFunction<ConnectorSession, Block, Object> function = type.getJavaType() == Long.TYPE ? (session, block) -> type.getLong(block, position) : (type.getJavaType() == Double.TYPE ? (session, block) -> type.getDouble(block, position) : (type.getJavaType() == Boolean.TYPE ? (session, block) -> type.getBoolean(block, position) : (type.getJavaType() == Slice.class ? (session, block) -> type.getSlice(block, position) : (session, block) -> type.getObject(block, position))));
        MethodHandle handle = functionDependencies.getCastInvoker(type, (Type)VarcharType.VARCHAR, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle();
        return (session, block) -> FormatFunction.convertToString(handle, function.apply((ConnectorSession)session, (Block)block));
    }

    private static LocalTime toLocalTime(long value) {
        long nanoOfDay = Timestamps.roundDiv((long)value, (long)1000L);
        return LocalTime.ofNanoOfDay(nanoOfDay);
    }

    private static Object convertToString(MethodHandle handle, Object value) {
        try {
            return handle.invoke(value).toStringUtf8();
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

