/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.collect.ImmutableList;
import io.trino.operator.project.InputChannels;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PageFieldsToInputParametersRewriter {
    private PageFieldsToInputParametersRewriter() {
    }

    public static Result rewritePageFieldsToInputParameters(RowExpression expression) {
        Visitor visitor = new Visitor();
        RowExpression rewrittenProjection = expression.accept(visitor, null);
        InputChannels inputChannels = new InputChannels(visitor.getInputChannels());
        return new Result(rewrittenProjection, inputChannels);
    }

    private static class Visitor
    implements RowExpressionVisitor<RowExpression, Void> {
        private final Map<Integer, Integer> fieldToParameter = new HashMap<Integer, Integer>();
        private final List<Integer> inputChannels = new ArrayList<Integer>();
        private int nextParameter;

        private Visitor() {
        }

        public List<Integer> getInputChannels() {
            return ImmutableList.copyOf(this.inputChannels);
        }

        @Override
        public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
            int parameter = this.getParameterForField(reference);
            return Expressions.field(parameter, reference.getType());
        }

        private Integer getParameterForField(InputReferenceExpression reference) {
            return this.fieldToParameter.computeIfAbsent(reference.getField(), field -> {
                this.inputChannels.add((Integer)field);
                return this.nextParameter++;
            });
        }

        @Override
        public RowExpression visitCall(CallExpression call, Void context) {
            return new CallExpression(call.getResolvedFunction(), (List)call.getArguments().stream().map(expression -> expression.accept(this, context)).collect(ImmutableList.toImmutableList()));
        }

        @Override
        public RowExpression visitSpecialForm(SpecialForm specialForm, Void context) {
            return new SpecialForm(specialForm.getForm(), specialForm.getType(), (List)specialForm.getArguments().stream().map(expression -> expression.accept(this, context)).collect(ImmutableList.toImmutableList()), specialForm.getFunctionDependencies());
        }

        @Override
        public RowExpression visitConstant(ConstantExpression literal, Void context) {
            return literal;
        }

        @Override
        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return new LambdaDefinitionExpression(lambda.getArgumentTypes(), lambda.getArguments(), lambda.getBody().accept(this, context));
        }

        @Override
        public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
            return reference;
        }
    }

    public static class Result {
        private final RowExpression rewrittenExpression;
        private final InputChannels inputChannels;

        public Result(RowExpression rewrittenExpression, InputChannels inputChannels) {
            this.rewrittenExpression = rewrittenExpression;
            this.inputChannels = inputChannels;
        }

        public RowExpression getRewrittenExpression() {
            return this.rewrittenExpression;
        }

        public InputChannels getInputChannels() {
            return this.inputChannels;
        }
    }
}

