/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.HashGenerator;
import io.trino.operator.OperatorInfo;
import io.trino.operator.PageBuffer;
import io.trino.operator.ProcessorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperatorAdapter;
import io.trino.operator.join.DefaultPageJoiner;
import io.trino.operator.join.JoinProbe;
import io.trino.operator.join.JoinStatisticsCounter;
import io.trino.operator.join.LookupJoinOperatorFactory;
import io.trino.operator.join.LookupSourceFactory;
import io.trino.operator.join.LookupSourceProvider;
import io.trino.operator.join.PageJoiner;
import io.trino.operator.join.SpillingJoinProcessor;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.spiller.PartitioningSpillerFactory;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public class LookupJoinOperator
implements WorkProcessorOperatorAdapter.AdapterWorkProcessorOperator {
    private final ListenableFuture<LookupSourceProvider> lookupSourceProviderFuture;
    private final boolean waitForBuild;
    private final PageBuffer pageBuffer;
    private final WorkProcessor<Page> pages;
    private final SpillingJoinProcessor joinProcessor;
    private final JoinStatisticsCounter statisticsCounter;

    LookupJoinOperator(List<Type> probeTypes, List<Type> buildOutputTypes, LookupJoinOperatorFactory.JoinType joinType, boolean outputSingleMatch, boolean waitForBuild, LookupSourceFactory lookupSourceFactory, JoinProbe.JoinProbeFactory joinProbeFactory, Runnable afterClose, OptionalInt lookupJoinsCount, HashGenerator hashGenerator, PartitioningSpillerFactory partitioningSpillerFactory, ProcessorContext processorContext, Optional<WorkProcessor<Page>> sourcePages) {
        this.statisticsCounter = new JoinStatisticsCounter(joinType);
        this.waitForBuild = waitForBuild;
        this.lookupSourceProviderFuture = lookupSourceFactory.createLookupSourceProvider();
        this.pageBuffer = new PageBuffer();
        PageJoiner.PageJoinerFactory pageJoinerFactory = (lookupSourceProvider, joinerPartitioningSpillerFactory, savedRows) -> new DefaultPageJoiner(processorContext, probeTypes, buildOutputTypes, joinType, outputSingleMatch, hashGenerator, joinProbeFactory, lookupSourceFactory, (ListenableFuture<LookupSourceProvider>)lookupSourceProvider, joinerPartitioningSpillerFactory, this.statisticsCounter, savedRows);
        this.joinProcessor = new SpillingJoinProcessor(afterClose, lookupJoinsCount, waitForBuild, lookupSourceFactory, this.lookupSourceProviderFuture, partitioningSpillerFactory, pageJoinerFactory, sourcePages.orElse(this.pageBuffer.pages()));
        this.pages = WorkProcessor.flatten(WorkProcessor.create(this.joinProcessor));
    }

    @Override
    public Optional<OperatorInfo> getOperatorInfo() {
        return Optional.of(this.statisticsCounter.get());
    }

    @Override
    public boolean needsInput() {
        return (!this.waitForBuild || this.lookupSourceProviderFuture.isDone()) && this.pageBuffer.isEmpty() && !this.pageBuffer.isFinished();
    }

    @Override
    public void addInput(Page page) {
        this.pageBuffer.add(page);
    }

    @Override
    public void finish() {
        this.pageBuffer.finish();
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    @Override
    public void close() {
        this.joinProcessor.close();
    }
}

