/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.project.InputChannels;
import io.trino.operator.project.PageFilter;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.type.BlockTypeOperators;
import java.util.List;
import java.util.Objects;

public class TuplePageFilter
implements PageFilter {
    private final Page tuplePage;
    private final InputChannels inputChannels;
    private final List<BlockTypeOperators.BlockPositionEqual> equalOperators;
    private boolean[] selectedPositions = new boolean[0];

    public TuplePageFilter(Page tuplePage, List<BlockTypeOperators.BlockPositionEqual> equalOperators, List<Integer> inputChannels) {
        Objects.requireNonNull(tuplePage, "tuplePage is null");
        Objects.requireNonNull(equalOperators, "equalOperators is null");
        Objects.requireNonNull(inputChannels, "inputChannels is null");
        Preconditions.checkArgument((tuplePage.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"tuplePage should only have one position");
        Preconditions.checkArgument((tuplePage.getChannelCount() == inputChannels.size() ? 1 : 0) != 0, (Object)"tuplePage and inputChannels have different number of channels");
        Preconditions.checkArgument((equalOperators.size() == inputChannels.size() ? 1 : 0) != 0, (Object)"equalOperators and inputChannels have different number of channels");
        this.tuplePage = tuplePage;
        this.equalOperators = ImmutableList.copyOf(equalOperators);
        this.inputChannels = new InputChannels(inputChannels);
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public SelectedPositions filter(ConnectorSession session, Page page) {
        if (this.selectedPositions.length < page.getPositionCount()) {
            this.selectedPositions = new boolean[page.getPositionCount()];
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            this.selectedPositions[position] = this.matches(page, position);
        }
        return PageFilter.positionsArrayToSelectedPositions(this.selectedPositions, page.getPositionCount());
    }

    private boolean matches(Page page, int position) {
        for (int channel = 0; channel < this.inputChannels.size(); ++channel) {
            BlockTypeOperators.BlockPositionEqual equalOperator = this.equalOperators.get(channel);
            Block outputBlock = page.getBlock(channel);
            Block singleTupleBlock = this.tuplePage.getBlock(channel);
            if (equalOperator.equal(singleTupleBlock, 0, outputBlock, position).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

