/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.stats.QuantileDigest;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationFunctionAdapter;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.FloatingPointBitsConverterUtil;
import io.trino.operator.aggregation.state.QuantileDigestState;
import io.trino.operator.aggregation.state.QuantileDigestStateFactory;
import io.trino.operator.aggregation.state.QuantileDigestStateSerializer;
import io.trino.operator.scalar.QuantileDigestFunctions;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.QuantileDigestType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class QuantileDigestAggregationFunction
extends SqlAggregationFunction {
    public static final QuantileDigestAggregationFunction QDIGEST_AGG = new QuantileDigestAggregationFunction(new TypeSignature("V", new TypeSignatureParameter[0]));
    public static final QuantileDigestAggregationFunction QDIGEST_AGG_WITH_WEIGHT = new QuantileDigestAggregationFunction(new TypeSignature("V", new TypeSignatureParameter[0]), BigintType.BIGINT.getTypeSignature());
    public static final QuantileDigestAggregationFunction QDIGEST_AGG_WITH_WEIGHT_AND_ERROR = new QuantileDigestAggregationFunction(new TypeSignature("V", new TypeSignatureParameter[0]), BigintType.BIGINT.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature());
    public static final String NAME = "qdigest_agg";
    private static final MethodHandle INPUT_DOUBLE = Reflection.methodHandle(QuantileDigestAggregationFunction.class, "inputDouble", QuantileDigestState.class, Double.TYPE, Long.TYPE, Double.TYPE);
    private static final MethodHandle INPUT_REAL = Reflection.methodHandle(QuantileDigestAggregationFunction.class, "inputReal", QuantileDigestState.class, Long.TYPE, Long.TYPE, Double.TYPE);
    private static final MethodHandle INPUT_BIGINT = Reflection.methodHandle(QuantileDigestAggregationFunction.class, "inputBigint", QuantileDigestState.class, Long.TYPE, Long.TYPE, Double.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(QuantileDigestAggregationFunction.class, "combineState", QuantileDigestState.class, QuantileDigestState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(QuantileDigestAggregationFunction.class, "evaluateFinal", QuantileDigestStateSerializer.class, QuantileDigestState.class, BlockBuilder.class);

    private QuantileDigestAggregationFunction(TypeSignature ... typeSignatures) {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parametricType((String)"qdigest", (TypeSignature[])new TypeSignature[]{new TypeSignature("V", new TypeSignatureParameter[0])}), (List<TypeSignature>)ImmutableList.copyOf((Object[])typeSignatures), false), new FunctionNullability(true, Collections.nCopies(typeSignatures.length, false)), false, true, "Returns a qdigest from the set of reals, bigints or doubles", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(true, TypeSignature.parametricType((String)"qdigest", (TypeSignature[])new TypeSignature[]{new TypeSignature("V", new TypeSignatureParameter[0])})));
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        QuantileDigestType outputType = (QuantileDigestType)boundSignature.getReturnType();
        Type valueType = outputType.getValueType();
        int arity = boundSignature.getArity();
        QuantileDigestStateSerializer stateSerializer = new QuantileDigestStateSerializer(valueType);
        MethodHandle inputFunction = QuantileDigestAggregationFunction.getMethodHandle(valueType, arity);
        inputFunction = AggregationFunctionAdapter.normalizeInputMethod(inputFunction, boundSignature, (List<AggregationFunctionAdapter.AggregationParameterKind>)ImmutableList.builder().add((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE).addAll((Iterable)QuantileDigestAggregationFunction.getInputTypes(valueType, arity).stream().map(ignored -> AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL).collect(Collectors.toList())).build());
        return new AggregationMetadata(inputFunction, Optional.empty(), Optional.of(COMBINE_FUNCTION), OUTPUT_FUNCTION.bindTo(stateSerializer), (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<QuantileDigestState>(QuantileDigestState.class, stateSerializer, new QuantileDigestStateFactory())));
    }

    private static List<Type> getInputTypes(Type valueType, int arity) {
        switch (arity) {
            case 1: {
                return ImmutableList.of((Object)valueType);
            }
            case 2: {
                return ImmutableList.of((Object)valueType, (Object)BigintType.BIGINT);
            }
            case 3: {
                return ImmutableList.of((Object)valueType, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported number of arguments: %s", arity));
    }

    private static MethodHandle getMethodHandle(Type valueType, int arity) {
        MethodHandle inputFunction;
        switch (valueType.getDisplayName()) {
            case "double": {
                inputFunction = INPUT_DOUBLE;
                break;
            }
            case "real": {
                inputFunction = INPUT_REAL;
                break;
            }
            case "bigint": {
                inputFunction = INPUT_BIGINT;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported type %s supplied", valueType.getDisplayName()));
            }
        }
        switch (arity) {
            case 1: {
                return MethodHandles.insertArguments(inputFunction, 2, 1L, 0.01);
            }
            case 2: {
                return MethodHandles.insertArguments(inputFunction, 3, 0.01);
            }
            case 3: {
                return inputFunction;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported number of arguments: %s", arity));
    }

    public static void inputDouble(QuantileDigestState state, double value, long weight, double accuracy) {
        QuantileDigestAggregationFunction.inputBigint(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), weight, accuracy);
    }

    public static void inputReal(QuantileDigestState state, long value, long weight, double accuracy) {
        QuantileDigestAggregationFunction.inputBigint(state, FloatingPointBitsConverterUtil.floatToSortableInt(Float.intBitsToFloat((int)value)), weight, accuracy);
    }

    public static void inputBigint(QuantileDigestState state, long value, long weight, double accuracy) {
        QuantileDigest qdigest = QuantileDigestAggregationFunction.getOrCreateQuantileDigest(state, QuantileDigestFunctions.verifyAccuracy(accuracy));
        state.addMemoryUsage(-qdigest.estimatedInMemorySizeInBytes());
        qdigest.add(value, QuantileDigestFunctions.verifyWeight(weight));
        state.addMemoryUsage(qdigest.estimatedInMemorySizeInBytes());
    }

    private static QuantileDigest getOrCreateQuantileDigest(QuantileDigestState state, double accuracy) {
        QuantileDigest qdigest = state.getQuantileDigest();
        if (qdigest == null) {
            qdigest = new QuantileDigest(accuracy);
            state.setQuantileDigest(qdigest);
            state.addMemoryUsage(qdigest.estimatedInMemorySizeInBytes());
        }
        return qdigest;
    }

    public static void combineState(QuantileDigestState state, QuantileDigestState otherState) {
        QuantileDigest input = otherState.getQuantileDigest();
        QuantileDigest previous = state.getQuantileDigest();
        if (previous == null) {
            state.setQuantileDigest(input);
            state.addMemoryUsage(input.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySizeInBytes());
            previous.merge(input);
            state.addMemoryUsage(previous.estimatedInMemorySizeInBytes());
        }
    }

    public static void evaluateFinal(QuantileDigestStateSerializer serializer, QuantileDigestState state, BlockBuilder out) {
        serializer.serialize(state, out);
    }
}

