/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.connector.CatalogName;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.TableProcedureMetadata;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class TableProceduresRegistry {
    private final Map<CatalogName, Map<String, TableProcedureMetadata>> tableProcedures = new ConcurrentHashMap<CatalogName, Map<String, TableProcedureMetadata>>();

    public void addTableProcedures(CatalogName catalogName, Collection<TableProcedureMetadata> procedures) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(procedures, "procedures is null");
        ImmutableMap proceduresByName = Maps.uniqueIndex(procedures, TableProcedureMetadata::getName);
        Preconditions.checkState((this.tableProcedures.putIfAbsent(catalogName, (Map<String, TableProcedureMetadata>)proceduresByName) == null ? 1 : 0) != 0, (String)"Table procedures already registered for connector: %s", (Object)catalogName);
    }

    public void removeProcedures(CatalogName catalogName) {
        this.tableProcedures.remove(catalogName);
    }

    public TableProcedureMetadata resolve(CatalogName catalogName, String name) {
        Map<String, TableProcedureMetadata> procedures = this.tableProcedures.get(catalogName);
        if (procedures == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Catalog %s not registered", catalogName));
        }
        TableProcedureMetadata procedure = procedures.get(name);
        if (procedure == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.PROCEDURE_NOT_FOUND, String.format("Procedure %s not registered for catalog %s", name, catalogName));
        }
        return procedure;
    }
}

