/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ViewDefinition;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetViewAuthorization;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class SetViewAuthorizationTask
implements DataDefinitionTask<SetViewAuthorization> {
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final boolean isAllowSetViewAuthorization;

    @Inject
    public SetViewAuthorizationTask(Metadata metadata, AccessControl accessControl, FeaturesConfig featuresConfig) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.isAllowSetViewAuthorization = Objects.requireNonNull(featuresConfig, "featuresConfig is null").isAllowSetViewAuthorization();
    }

    @Override
    public String getName() {
        return "SET VIEW AUTHORIZATION";
    }

    @Override
    public ListenableFuture<Void> execute(SetViewAuthorization statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getSource());
        MetadataUtil.getRequiredCatalogHandle(this.metadata, session, (Node)statement, viewName.getCatalogName());
        ViewDefinition view = this.metadata.getView(session, viewName).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist", viewName));
        TrinoPrincipal principal = MetadataUtil.createPrincipal(statement.getPrincipal());
        MetadataUtil.checkRoleExists(session, (Node)statement, this.metadata, principal, Optional.of(viewName.getCatalogName()).filter(catalog -> this.metadata.isCatalogManagedSecurity(session, (String)catalog)));
        if (!view.isRunAsInvoker() && !this.isAllowSetViewAuthorization) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Cannot set authorization for view %s to %s: this feature is disabled", viewName.getCatalogName() + "." + viewName.getSchemaName() + "." + viewName.getObjectName(), principal));
        }
        this.accessControl.checkCanSetViewAuthorization(session.toSecurityContext(), viewName, principal);
        this.metadata.setViewAuthorization(session, viewName.asCatalogSchemaTableName(), principal);
        return Futures.immediateVoidFuture();
    }
}

