/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class HistoryUpdateResult extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 697;
  }

  // Properties.
  protected final StatusCode statusCode;
  protected final List<StatusCode> operationResults;
  protected final List<DiagnosticInfo> diagnosticInfos;

  public HistoryUpdateResult(
      StatusCode statusCode,
      List<StatusCode> operationResults,
      List<DiagnosticInfo> diagnosticInfos) {
    super();
    this.statusCode = statusCode;
    this.operationResults = operationResults;
    this.diagnosticInfos = diagnosticInfos;
  }

  public StatusCode getStatusCode() {
    return statusCode;
  }

  public List<StatusCode> getOperationResults() {
    return operationResults;
  }

  public List<DiagnosticInfo> getDiagnosticInfos() {
    return diagnosticInfos;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("HistoryUpdateResult");

    // Simple Field (statusCode)
    writeSimpleField("statusCode", statusCode, writeComplex(writeBuffer));

    // Implicit Field (noOfOperationResults) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfOperationResults =
        (int) ((((getOperationResults()) == (null)) ? -(1) : COUNT(getOperationResults())));
    writeImplicitField(
        "noOfOperationResults", noOfOperationResults, writeSignedInt(writeBuffer, 32));

    // Array Field (operationResults)
    writeComplexTypeArrayField("operationResults", operationResults, writeBuffer);

    // Implicit Field (noOfDiagnosticInfos) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfDiagnosticInfos =
        (int) ((((getDiagnosticInfos()) == (null)) ? -(1) : COUNT(getDiagnosticInfos())));
    writeImplicitField("noOfDiagnosticInfos", noOfDiagnosticInfos, writeSignedInt(writeBuffer, 32));

    // Array Field (diagnosticInfos)
    writeComplexTypeArrayField("diagnosticInfos", diagnosticInfos, writeBuffer);

    writeBuffer.popContext("HistoryUpdateResult");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    HistoryUpdateResult _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (statusCode)
    lengthInBits += statusCode.getLengthInBits();

    // Implicit Field (noOfOperationResults)
    lengthInBits += 32;

    // Array field
    if (operationResults != null) {
      int i = 0;
      for (StatusCode element : operationResults) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= operationResults.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfDiagnosticInfos)
    lengthInBits += 32;

    // Array field
    if (diagnosticInfos != null) {
      int i = 0;
      for (DiagnosticInfo element : diagnosticInfos) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= diagnosticInfos.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("HistoryUpdateResult");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    StatusCode statusCode =
        readSimpleField(
            "statusCode", readComplex(() -> StatusCode.staticParse(readBuffer), readBuffer));

    int noOfOperationResults =
        readImplicitField("noOfOperationResults", readSignedInt(readBuffer, 32));

    List<StatusCode> operationResults =
        readCountArrayField(
            "operationResults",
            readComplex(() -> StatusCode.staticParse(readBuffer), readBuffer),
            noOfOperationResults);

    int noOfDiagnosticInfos =
        readImplicitField("noOfDiagnosticInfos", readSignedInt(readBuffer, 32));

    List<DiagnosticInfo> diagnosticInfos =
        readCountArrayField(
            "diagnosticInfos",
            readComplex(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer),
            noOfDiagnosticInfos);

    readBuffer.closeContext("HistoryUpdateResult");
    // Create the instance
    return new HistoryUpdateResultBuilderImpl(statusCode, operationResults, diagnosticInfos);
  }

  public static class HistoryUpdateResultBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final StatusCode statusCode;
    private final List<StatusCode> operationResults;
    private final List<DiagnosticInfo> diagnosticInfos;

    public HistoryUpdateResultBuilderImpl(
        StatusCode statusCode,
        List<StatusCode> operationResults,
        List<DiagnosticInfo> diagnosticInfos) {
      this.statusCode = statusCode;
      this.operationResults = operationResults;
      this.diagnosticInfos = diagnosticInfos;
    }

    public HistoryUpdateResult build() {
      HistoryUpdateResult historyUpdateResult =
          new HistoryUpdateResult(statusCode, operationResults, diagnosticInfos);
      return historyUpdateResult;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof HistoryUpdateResult)) {
      return false;
    }
    HistoryUpdateResult that = (HistoryUpdateResult) o;
    return (getStatusCode() == that.getStatusCode())
        && (getOperationResults() == that.getOperationResults())
        && (getDiagnosticInfos() == that.getDiagnosticInfos())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getStatusCode(), getOperationResults(), getDiagnosticInfos());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
