/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetTagPayloadEnumerated implements Message {

  // Properties.
  protected final byte[] data;

  // Arguments.
  protected final Long actualLength;

  public BACnetTagPayloadEnumerated(byte[] data, Long actualLength) {
    super();
    this.data = data;
    this.actualLength = actualLength;
  }

  public byte[] getData() {
    return data;
  }

  public long getActualValue() {
    return (long)
        (org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper.parseVarUint(getData()));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetTagPayloadEnumerated");

    // Array Field (data)
    writeByteArrayField("data", data, writeByteArray(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    long actualValue = getActualValue();
    writeBuffer.writeVirtual("actualValue", actualValue);

    writeBuffer.popContext("BACnetTagPayloadEnumerated");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetTagPayloadEnumerated _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Array field
    if (data != null) {
      lengthInBits += 8 * data.length;
    }

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static BACnetTagPayloadEnumerated staticParse(ReadBuffer readBuffer, Long actualLength)
      throws ParseException {
    readBuffer.pullContext("BACnetTagPayloadEnumerated");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte[] data = readBuffer.readByteArray("data", Math.toIntExact(actualLength));
    long actualValue =
        readVirtualField(
            "actualValue",
            long.class,
            org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper.parseVarUint(data));

    readBuffer.closeContext("BACnetTagPayloadEnumerated");
    // Create the instance
    BACnetTagPayloadEnumerated _bACnetTagPayloadEnumerated;
    _bACnetTagPayloadEnumerated = new BACnetTagPayloadEnumerated(data, actualLength);
    return _bACnetTagPayloadEnumerated;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetTagPayloadEnumerated)) {
      return false;
    }
    BACnetTagPayloadEnumerated that = (BACnetTagPayloadEnumerated) o;
    return (getData() == that.getData()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
