/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetServiceAckAtomicReadFileRecord
    extends BACnetServiceAckAtomicReadFileStreamOrRecord implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetApplicationTagSignedInteger fileStartRecord;
  protected final BACnetApplicationTagUnsignedInteger returnedRecordCount;
  protected final List<BACnetApplicationTagOctetString> fileRecordData;

  public BACnetServiceAckAtomicReadFileRecord(
      BACnetTagHeader peekedTagHeader,
      BACnetOpeningTag openingTag,
      BACnetClosingTag closingTag,
      BACnetApplicationTagSignedInteger fileStartRecord,
      BACnetApplicationTagUnsignedInteger returnedRecordCount,
      List<BACnetApplicationTagOctetString> fileRecordData) {
    super(peekedTagHeader, openingTag, closingTag);
    this.fileStartRecord = fileStartRecord;
    this.returnedRecordCount = returnedRecordCount;
    this.fileRecordData = fileRecordData;
  }

  public BACnetApplicationTagSignedInteger getFileStartRecord() {
    return fileStartRecord;
  }

  public BACnetApplicationTagUnsignedInteger getReturnedRecordCount() {
    return returnedRecordCount;
  }

  public List<BACnetApplicationTagOctetString> getFileRecordData() {
    return fileRecordData;
  }

  @Override
  protected void serializeBACnetServiceAckAtomicReadFileStreamOrRecordChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetServiceAckAtomicReadFileRecord");

    // Simple Field (fileStartRecord)
    writeSimpleField("fileStartRecord", fileStartRecord, writeComplex(writeBuffer));

    // Simple Field (returnedRecordCount)
    writeSimpleField("returnedRecordCount", returnedRecordCount, writeComplex(writeBuffer));

    // Array Field (fileRecordData)
    writeComplexTypeArrayField("fileRecordData", fileRecordData, writeBuffer);

    writeBuffer.popContext("BACnetServiceAckAtomicReadFileRecord");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetServiceAckAtomicReadFileRecord _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (fileStartRecord)
    lengthInBits += fileStartRecord.getLengthInBits();

    // Simple field (returnedRecordCount)
    lengthInBits += returnedRecordCount.getLengthInBits();

    // Array field
    if (fileRecordData != null) {
      int i = 0;
      for (BACnetApplicationTagOctetString element : fileRecordData) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= fileRecordData.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static BACnetServiceAckAtomicReadFileStreamOrRecordBuilder
      staticParseBACnetServiceAckAtomicReadFileStreamOrRecordBuilder(ReadBuffer readBuffer)
          throws ParseException {
    readBuffer.pullContext("BACnetServiceAckAtomicReadFileRecord");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetApplicationTagSignedInteger fileStartRecord =
        readSimpleField(
            "fileStartRecord",
            readComplex(
                () ->
                    (BACnetApplicationTagSignedInteger)
                        BACnetApplicationTag.staticParse(readBuffer),
                readBuffer));

    BACnetApplicationTagUnsignedInteger returnedRecordCount =
        readSimpleField(
            "returnedRecordCount",
            readComplex(
                () ->
                    (BACnetApplicationTagUnsignedInteger)
                        BACnetApplicationTag.staticParse(readBuffer),
                readBuffer));

    List<BACnetApplicationTagOctetString> fileRecordData =
        readCountArrayField(
            "fileRecordData",
            readComplex(
                () ->
                    (BACnetApplicationTagOctetString) BACnetApplicationTag.staticParse(readBuffer),
                readBuffer),
            returnedRecordCount.getPayload().getActualValue());

    readBuffer.closeContext("BACnetServiceAckAtomicReadFileRecord");
    // Create the instance
    return new BACnetServiceAckAtomicReadFileRecordBuilderImpl(
        fileStartRecord, returnedRecordCount, fileRecordData);
  }

  public static class BACnetServiceAckAtomicReadFileRecordBuilderImpl
      implements BACnetServiceAckAtomicReadFileStreamOrRecord
          .BACnetServiceAckAtomicReadFileStreamOrRecordBuilder {
    private final BACnetApplicationTagSignedInteger fileStartRecord;
    private final BACnetApplicationTagUnsignedInteger returnedRecordCount;
    private final List<BACnetApplicationTagOctetString> fileRecordData;

    public BACnetServiceAckAtomicReadFileRecordBuilderImpl(
        BACnetApplicationTagSignedInteger fileStartRecord,
        BACnetApplicationTagUnsignedInteger returnedRecordCount,
        List<BACnetApplicationTagOctetString> fileRecordData) {
      this.fileStartRecord = fileStartRecord;
      this.returnedRecordCount = returnedRecordCount;
      this.fileRecordData = fileRecordData;
    }

    public BACnetServiceAckAtomicReadFileRecord build(
        BACnetTagHeader peekedTagHeader, BACnetOpeningTag openingTag, BACnetClosingTag closingTag) {
      BACnetServiceAckAtomicReadFileRecord bACnetServiceAckAtomicReadFileRecord =
          new BACnetServiceAckAtomicReadFileRecord(
              peekedTagHeader,
              openingTag,
              closingTag,
              fileStartRecord,
              returnedRecordCount,
              fileRecordData);
      return bACnetServiceAckAtomicReadFileRecord;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetServiceAckAtomicReadFileRecord)) {
      return false;
    }
    BACnetServiceAckAtomicReadFileRecord that = (BACnetServiceAckAtomicReadFileRecord) o;
    return (getFileStartRecord() == that.getFileStartRecord())
        && (getReturnedRecordCount() == that.getReturnedRecordCount())
        && (getFileRecordData() == that.getFileRecordData())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getFileStartRecord(), getReturnedRecordCount(), getFileRecordData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
