/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableRational is an enum
type OpcuaNodeIdServicesVariableRational int32

type IOpcuaNodeIdServicesVariableRational interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableRational_RationalNumberType_Numerator   OpcuaNodeIdServicesVariableRational = 17712
	OpcuaNodeIdServicesVariableRational_RationalNumberType_Denominator OpcuaNodeIdServicesVariableRational = 17713
)

var OpcuaNodeIdServicesVariableRationalValues []OpcuaNodeIdServicesVariableRational

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableRationalValues = []OpcuaNodeIdServicesVariableRational{
		OpcuaNodeIdServicesVariableRational_RationalNumberType_Numerator,
		OpcuaNodeIdServicesVariableRational_RationalNumberType_Denominator,
	}
}

func OpcuaNodeIdServicesVariableRationalByValue(value int32) (enum OpcuaNodeIdServicesVariableRational, ok bool) {
	switch value {
	case 17712:
		return OpcuaNodeIdServicesVariableRational_RationalNumberType_Numerator, true
	case 17713:
		return OpcuaNodeIdServicesVariableRational_RationalNumberType_Denominator, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableRationalByName(value string) (enum OpcuaNodeIdServicesVariableRational, ok bool) {
	switch value {
	case "RationalNumberType_Numerator":
		return OpcuaNodeIdServicesVariableRational_RationalNumberType_Numerator, true
	case "RationalNumberType_Denominator":
		return OpcuaNodeIdServicesVariableRational_RationalNumberType_Denominator, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableRationalKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableRationalValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableRational(structType any) OpcuaNodeIdServicesVariableRational {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableRational {
		if sOpcuaNodeIdServicesVariableRational, ok := typ.(OpcuaNodeIdServicesVariableRational); ok {
			return sOpcuaNodeIdServicesVariableRational
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableRational) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableRational) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableRationalParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableRational, error) {
	return OpcuaNodeIdServicesVariableRationalParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableRationalParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableRational, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableRational", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableRational")
	}
	if enum, ok := OpcuaNodeIdServicesVariableRationalByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableRational")
		return OpcuaNodeIdServicesVariableRational(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableRational) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableRational) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableRational", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableRational) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableRational) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableRational_RationalNumberType_Numerator:
		return "RationalNumberType_Numerator"
	case OpcuaNodeIdServicesVariableRational_RationalNumberType_Denominator:
		return "RationalNumberType_Denominator"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableRational) String() string {
	return e.PLC4XEnumName()
}
