/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Counter is the corresponding interface of Counter
type Counter interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsCounter is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCounter()
	// CreateBuilder creates a CounterBuilder
	CreateCounterBuilder() CounterBuilder
}

// _Counter is the data-structure of this message
type _Counter struct {
}

var _ Counter = (*_Counter)(nil)

// NewCounter factory function for _Counter
func NewCounter() *_Counter {
	return &_Counter{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CounterBuilder is a builder for Counter
type CounterBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() CounterBuilder
	// Build builds the Counter or returns an error if something is wrong
	Build() (Counter, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() Counter
}

// NewCounterBuilder() creates a CounterBuilder
func NewCounterBuilder() CounterBuilder {
	return &_CounterBuilder{_Counter: new(_Counter)}
}

type _CounterBuilder struct {
	*_Counter

	collectedErr []error
}

var _ (CounterBuilder) = (*_CounterBuilder)(nil)

func (b *_CounterBuilder) WithMandatoryFields() CounterBuilder {
	return b
}

func (b *_CounterBuilder) Build() (Counter, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._Counter.deepCopy(), nil
}

func (b *_CounterBuilder) MustBuild() Counter {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CounterBuilder) DeepCopy() any {
	_copy := b.CreateCounterBuilder().(*_CounterBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateCounterBuilder creates a CounterBuilder
func (b *_Counter) CreateCounterBuilder() CounterBuilder {
	if b == nil {
		return NewCounterBuilder()
	}
	return &_CounterBuilder{_Counter: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCounter(structType any) Counter {
	if casted, ok := structType.(Counter); ok {
		return casted
	}
	if casted, ok := structType.(*Counter); ok {
		return *casted
	}
	return nil
}

func (m *_Counter) GetTypeName() string {
	return "Counter"
}

func (m *_Counter) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_Counter) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func CounterParse(ctx context.Context, theBytes []byte) (Counter, error) {
	return CounterParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func CounterParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (Counter, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (Counter, error) {
		return CounterParseWithBuffer(ctx, readBuffer)
	}
}

func CounterParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (Counter, error) {
	v, err := (&_Counter{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_Counter) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__counter Counter, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("Counter"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for Counter")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("Counter"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for Counter")
	}

	return m, nil
}

func (m *_Counter) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_Counter) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("Counter"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for Counter")
	}

	if popErr := writeBuffer.PopContext("Counter"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for Counter")
	}
	return nil
}

func (m *_Counter) IsCounter() {}

func (m *_Counter) DeepCopy() any {
	return m.deepCopy()
}

func (m *_Counter) deepCopy() *_Counter {
	if m == nil {
		return nil
	}
	_CounterCopy := &_Counter{}
	return _CounterCopy
}

func (m *_Counter) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
